/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.potion;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.common.ConsecrationUtils;
import top.theillusivec4.consecration.common.capability.UndyingCapability;

public class HolyEffect
extends MobEffect {
    public HolyEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xFFFFFF);
        this.setRegistryName("consecration:holy");
    }

    public void m_19461_(@Nullable Entity source, @Nullable Entity indirectSource, @Nonnull LivingEntity livingEntity, int amplifier, double health) {
        if (livingEntity instanceof ZombieVillager) {
            this.convertZombieVillager((ZombieVillager)livingEntity, indirectSource, 1800 >> amplifier);
        } else if (ConsecrationUtils.isUndying(livingEntity)) {
            LazyOptional<UndyingCapability.IUndying> undyingOpt = UndyingCapability.getCapability(livingEntity);
            undyingOpt.ifPresent(undying -> {
                if (source == null) {
                    livingEntity.m_6469_(ConsecrationApi.getHolyRegistry().causeHolyDamage(), (float)(8 << amplifier));
                } else {
                    livingEntity.m_6469_(ConsecrationApi.getHolyRegistry().causeIndirectHolyDamage(source, indirectSource), (float)(8 << amplifier));
                }
            });
        } else {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 600, amplifier));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600, amplifier));
        }
    }

    public boolean m_8093_() {
        return true;
    }

    private void convertZombieVillager(ZombieVillager zombieVillager, @Nullable Entity source, int conversionTime) {
        if (zombieVillager.m_34408_()) {
            return;
        }
        UUID uuid = source instanceof Player ? source.m_142081_() : null;
        zombieVillager.m_34383_(uuid, conversionTime);
    }
}

