/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration;

import com.mojang.logging.LogUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.ItemHandlerHelper;
import org.slf4j.Logger;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.api.IUndying;
import top.theillusivec4.consecration.common.ConsecrationConfig;
import top.theillusivec4.consecration.common.HolySources;
import top.theillusivec4.consecration.common.capability.CapabilityEventsHandler;
import top.theillusivec4.consecration.common.impl.ConsecrationApiImpl;
import top.theillusivec4.consecration.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.consecration.common.integration.SilentGearModule;
import top.theillusivec4.consecration.common.integration.TConstructModule;
import top.theillusivec4.consecration.common.integration.TetraModule;
import top.theillusivec4.consecration.common.integration.WerewolvesModule;
import top.theillusivec4.consecration.common.network.ConsecrationNetwork;
import top.theillusivec4.consecration.common.registry.ConsecrationRegistry;
import top.theillusivec4.consecration.common.trigger.SmiteTrigger;

@Mod(value="consecration")
public class Consecration {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<String, Class<? extends AbstractCompatibilityModule>> MODULES = new HashMap<String, Class<? extends AbstractCompatibilityModule>>();
    public static final List<AbstractCompatibilityModule> ACTIVE_MODULES = new ArrayList<AbstractCompatibilityModule>();

    public Consecration() {
        ConsecrationApi.setInstance(new ConsecrationApiImpl());
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ConsecrationRegistry.setup(eventBus);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::registerCaps);
        eventBus.addListener(this::imcEnqueue);
        eventBus.addListener(this::imcProcess);
        eventBus.addListener(this::configLoading);
        eventBus.addListener(this::configReloading);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConsecrationConfig.CONFIG_SPEC);
        MODULES.forEach((id, module) -> {
            if (ModList.get().isLoaded(id)) {
                try {
                    ACTIVE_MODULES.add((AbstractCompatibilityModule)module.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.error("Error adding module for mod " + id);
                }
            }
        });
    }

    private void setup(FMLCommonSetupEvent evt) {
        ConsecrationNetwork.setup();
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEventsHandler());
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
        MinecraftForge.EVENT_BUS.addListener(this::makeCampfireArrow);
        evt.enqueueWork(() -> {
            CriteriaTriggers.m_10595_((CriterionTrigger)SmiteTrigger.INSTANCE);
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43602_)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42436_}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)ConsecrationRegistry.HOLY_POTION.get())));
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)ConsecrationRegistry.HOLY_POTION.get()))}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)ConsecrationRegistry.STRONG_HOLY_POTION.get())));
        });
    }

    private void imcEnqueue(InterModEnqueueEvent evt) {
        ACTIVE_MODULES.forEach(AbstractCompatibilityModule::enqueueImc);
    }

    private void imcProcess(InterModProcessEvent evt) {
        HolySources.processImc(evt.getIMCStream());
    }

    private void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.register(IUndying.class);
    }

    private void configLoading(ModConfigEvent.Loading evt) {
        if (evt.getConfig().getModId().equals("consecration")) {
            ConsecrationConfig.bake();
        }
    }

    private void configReloading(ModConfigEvent.Reloading evt) {
        if (evt.getConfig().getModId().equals("consecration")) {
            ConsecrationConfig.bake();
        }
    }

    private void serverStart(ServerAboutToStartEvent evt) {
        HolySources.setup();
    }

    private void makeCampfireArrow(PlayerInteractEvent.RightClickBlock evt) {
        Player player;
        Block block;
        ItemStack stack = evt.getItemStack();
        if (stack.m_41720_() == Items.f_42412_ && ((block = (player = evt.getPlayer()).m_20193_().m_8055_(evt.getPos()).m_60734_()) == Blocks.f_50683_ || block == Blocks.f_50684_)) {
            stack.m_41774_(1);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ConsecrationRegistry.FIRE_ARROW.get()), (int)player.m_150109_().f_35977_);
        }
    }

    static {
        MODULES.put("tetra", TetraModule.class);
        MODULES.put("tconstruct", TConstructModule.class);
        MODULES.put("werewolves", WerewolvesModule.class);
        MODULES.put("silentgear", SilentGearModule.class);
    }
}

