/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConsecrationConfig {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final Config CONFIG;
    private static final String CONFIG_PREFIX = "gui.consecration.config.";
    public static Set<ResourceLocation> dimensions;
    public static PermissionMode dimensionsPermission;
    public static int fireVulnerableDuration;
    public static int holyVulnerableDuration;
    public static List<? extends String> holyDamage;
    public static List<? extends String> holyMaterials;
    public static boolean giveDefaultUndeadUndying;
    public static double damageReduction;
    public static double healthRegeneration;
    public static double speedModifier;
    public static double damageReductionVsMobs;

    public static void bake() {
        dimensions = new HashSet<ResourceLocation>();
        ((List)ConsecrationConfig.CONFIG.dimensions.get()).forEach(dimension -> dimensions.add(new ResourceLocation(dimension)));
        dimensionsPermission = (PermissionMode)((Object)ConsecrationConfig.CONFIG.dimensionsPermission.get());
        fireVulnerableDuration = (Integer)ConsecrationConfig.CONFIG.fireVulnerableDuration.get();
        holyVulnerableDuration = (Integer)ConsecrationConfig.CONFIG.holyVulnerableDuration.get();
        holyDamage = (List)ConsecrationConfig.CONFIG.holyDamage.get();
        holyMaterials = (List)ConsecrationConfig.CONFIG.holyMaterials.get();
        giveDefaultUndeadUndying = (Boolean)ConsecrationConfig.CONFIG.giveDefaultUndeadUndying.get();
        damageReduction = (Double)ConsecrationConfig.CONFIG.damageReduction.get();
        healthRegeneration = ((Integer)ConsecrationConfig.CONFIG.healthRegeneration.get()).intValue();
        speedModifier = (Double)ConsecrationConfig.CONFIG.speedModifier.get();
        damageReductionVsMobs = (Double)ConsecrationConfig.CONFIG.damageReductionVsMobs.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (Config)specPair.getLeft();
    }

    public static class Config {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> dimensions;
        public final ForgeConfigSpec.EnumValue<PermissionMode> dimensionsPermission;
        public final ForgeConfigSpec.IntValue fireVulnerableDuration;
        public final ForgeConfigSpec.IntValue holyVulnerableDuration;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyDamage;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyMaterials;
        public final ForgeConfigSpec.BooleanValue giveDefaultUndeadUndying;
        public final ForgeConfigSpec.DoubleValue damageReduction;
        public final ForgeConfigSpec.IntValue healthRegeneration;
        public final ForgeConfigSpec.DoubleValue speedModifier;
        public final ForgeConfigSpec.DoubleValue damageReductionVsMobs;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.push("dimension");
            this.dimensions = builder.comment("Set which dimensions are blacklisted or whitelisted for empowered undead").translation("gui.consecration.config.dimensions").defineList("dimensions", ArrayList::new, s -> s instanceof String);
            this.dimensionsPermission = builder.comment("Set whether the dimension configuration is blacklisted or whitelisted").translation("gui.consecration.config.dimensionsPermission").defineEnum("dimensionsPermission", (Enum)PermissionMode.BLACKLIST);
            builder.pop();
            builder.push("vulnerability");
            this.fireVulnerableDuration = builder.comment("The amount of time, in seconds, that vulnerability from fire lasts").translation("gui.consecration.config.fireWeakeningDuration").defineInRange("fireWeakeningDuration", 10, 0, 100);
            this.holyVulnerableDuration = builder.comment("The amount of time, in seconds, that vulnerability from holy sources lasts").translation("gui.consecration.config.holyWeakeningDuration").defineInRange("holyWeakeningDuration", 10, 0, 100);
            this.holyDamage = builder.comment("A list of damage types that will be able to damage and make undead vulnerable").translation("gui.consecration.config.holyDamage").defineList("holyDamage", Collections.singletonList("holy"), s -> s instanceof String);
            this.holyMaterials = builder.comment("A list of materials that will be able to damage and make undead vulnerable").translation("gui.consecration.config.holyMaterials").defineList("holyMaterials", Collections.singletonList("silver"), s -> s instanceof String);
            builder.pop();
            builder.push("undying");
            this.giveDefaultUndeadUndying = builder.comment("Set to true to give default undead creatures the undying trait").translation("gui.consecration.config.giveDefaultUndeadUndying").define("giveDefaultUndeadUndying", true);
            this.damageReduction = builder.comment("Set undead natural damage reduction, in percent, against non-vulnerable damage").translation("gui.consecration.config.damageReduction").defineInRange("damageReduction", 0.8, 0.0, 1.0);
            this.healthRegeneration = builder.comment("Set undead natural health regeneration in half-hearts per second").translation("gui.consecration.config.healthRegeneration").defineInRange("healthRegeneration", 1, 0, 1000);
            this.speedModifier = builder.comment("Set undead natural bonus speed modifier").translation("gui.consecration.config.speedModifier").defineInRange("speedModifier", 0.0, 0.0, 100.0);
            this.damageReductionVsMobs = builder.comment("Set undead natural damage reduction, in percent, against non-vulnerable mob damage").translation("gui.consecration.config.damageReductionVsMobs").defineInRange("damageReductionVsMobs", 0.8, 0.0, 1.0);
            builder.pop();
        }
    }

    public static enum PermissionMode {
        BLACKLIST,
        WHITELIST;

    }
}

