/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.capability;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.api.IUndying;
import top.theillusivec4.consecration.api.VulnerabilityType;
import top.theillusivec4.consecration.common.ConsecrationConfig;
import top.theillusivec4.consecration.common.capability.Undying;
import top.theillusivec4.consecration.common.capability.UndyingCapability;
import top.theillusivec4.consecration.common.network.ConsecrationNetwork;
import top.theillusivec4.consecration.common.trigger.SmiteTrigger;

public class CapabilityEventsHandler {
    private static final UUID SPEED_MOD = UUID.fromString("b812ef3d-0ef9-4368-845b-fad7003a1f4f");

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Object object = evt.getObject();
        if (object instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)object;
            evt.addCapability(UndyingCapability.ID, (ICapabilityProvider)new Provider(livingEntity));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void invalidateCaps(EntityLeaveWorldEvent evt) {
        LivingEntity livingEntity;
        LazyOptional<IUndying> cap;
        Entity entity = evt.getEntity();
        if (entity instanceof LivingEntity && (cap = UndyingCapability.get(livingEntity = (LivingEntity)entity)).isPresent()) {
            cap.invalidate();
        }
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingUpdateEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.m_183503_().m_5776_()) {
            if (livingEntity.f_19797_ % 20 == 0) {
                ConsecrationApi.getInstance().getUndying(livingEntity).ifPresent(undying -> {
                    AttributeInstance speedAttribute = livingEntity.m_21051_(Attributes.f_22279_);
                    if (speedAttribute != null) {
                        speedAttribute.m_22120_(SPEED_MOD);
                    }
                    if (undying.isVulnerable()) {
                        undying.decrementVulnerability();
                    } else {
                        double speedMod;
                        if (livingEntity.m_21223_() < livingEntity.m_21233_()) {
                            livingEntity.m_5634_((float)ConsecrationConfig.healthRegeneration);
                        }
                        if ((speedMod = ConsecrationConfig.speedModifier) > 0.0 && speedAttribute != null && speedAttribute.m_22111_(SPEED_MOD) == null) {
                            speedAttribute.m_22118_(new AttributeModifier(SPEED_MOD, "Undead speed", speedMod, AttributeModifier.Operation.MULTIPLY_TOTAL));
                        }
                    }
                });
            }
        } else {
            ConsecrationApi.getInstance().getUndying(livingEntity).ifPresent(undying -> {
                if (undying.isVulnerable()) {
                    livingEntity.m_183503_().m_7106_((ParticleOptions)ParticleTypes.f_123751_, livingEntity.m_20182_().f_82479_ + (livingEntity.m_21187_().nextDouble() - 0.5) * (double)livingEntity.m_20205_(), livingEntity.m_20182_().f_82480_ + livingEntity.m_21187_().nextDouble() * (double)livingEntity.m_20206_(), livingEntity.m_20182_().f_82481_ + (livingEntity.m_21187_().nextDouble() - 0.5) * (double)livingEntity.m_20205_(), 0.0, 0.0, 0.0);
                }
                if (livingEntity.f_19797_ % 20 == 0) {
                    undying.decrementVulnerability();
                }
            });
        }
    }

    @SubscribeEvent
    public void potionAdded(PotionEvent.PotionAddedEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.m_183503_().m_5776_()) {
            ConsecrationApi.getInstance().getUndying(livingEntity).ifPresent(undying -> {
                MobEffectInstance effectInstance = evt.getPotionEffect();
                MobEffect effect = effectInstance.m_19544_();
                if (ConsecrationApi.getInstance().isHolyEffect(effect)) {
                    int duration = effect.m_8093_() ? ConsecrationConfig.holyVulnerableDuration : effectInstance.m_19557_();
                    undying.setVulnerableDuration(duration);
                }
            });
        }
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking evt) {
        LivingEntity livingEntity;
        Entity entity = evt.getTarget();
        if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_183503_().m_5776_()) {
            ConsecrationApi.getInstance().getUndying(livingEntity).ifPresent(undying -> ConsecrationNetwork.syncVulnerability((Entity)livingEntity, undying.getVulnerableDuration()));
        }
    }

    @SubscribeEvent
    public void livingDamage(LivingDamageEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.m_183503_().m_5776_()) {
            Entity entity;
            LazyOptional<IUndying> hurtUndying = ConsecrationApi.getInstance().getUndying(livingEntity);
            if (!hurtUndying.isPresent() && (entity = evt.getSource().m_7640_()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                LazyOptional<IUndying> attackerUndying = ConsecrationApi.getInstance().getUndying(attacker);
                attackerUndying.ifPresent(undying -> {
                    int level = ConsecrationApi.getInstance().getHolyProtectionLevel(attacker, livingEntity, evt.getSource());
                    if (level > 0 && livingEntity.m_183503_().m_5822_().nextFloat() < 0.15f * (float)level) {
                        undying.setVulnerableDuration(ConsecrationConfig.holyVulnerableDuration);
                    }
                });
            }
            hurtUndying.ifPresent(undying -> {
                Entity trueSource;
                DamageSource source = evt.getSource();
                if (source == DamageSource.f_19317_ || source == DamageSource.f_19311_ || source == DamageSource.f_19310_) {
                    return;
                }
                VulnerabilityType type = UndyingCapability.createVulnerability(livingEntity, source);
                if (type != VulnerabilityType.NONE) {
                    if (type == VulnerabilityType.FIRE) {
                        undying.setVulnerableDuration(ConsecrationConfig.fireVulnerableDuration);
                    } else {
                        undying.setVulnerableDuration(ConsecrationConfig.holyVulnerableDuration);
                    }
                    if (source.m_7639_() instanceof ServerPlayer) {
                        SmiteTrigger.INSTANCE.trigger((ServerPlayer)source.m_7639_());
                    }
                } else if (!source.m_19379_() && !undying.isVulnerable() && (trueSource = source.m_7639_()) != null) {
                    if (trueSource instanceof Player) {
                        evt.setAmount(evt.getAmount() * (float)(1.0 - ConsecrationConfig.damageReduction));
                    } else if (trueSource instanceof LivingEntity) {
                        evt.setAmount(evt.getAmount() * (float)(1.0 - ConsecrationConfig.damageReductionVsMobs));
                    }
                }
            });
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        final LazyOptional<IUndying> optional;
        final IUndying data;

        Provider(LivingEntity livingEntity) {
            this.data = new Undying(livingEntity);
            this.optional = LazyOptional.of(() -> this.data);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == UndyingCapability.INSTANCE ? this.optional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.data.writeTag();
        }

        public void deserializeNBT(CompoundTag tag) {
            this.data.readTag(tag);
        }
    }
}

