/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.capability;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.consecration.api.IUndying;
import top.theillusivec4.consecration.common.network.ConsecrationNetwork;

public class Undying
implements IUndying {
    private static final String SMITE_TAG = "smite";
    private final LivingEntity livingEntity;
    private int vulnerableDuration = 0;

    public Undying(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
    }

    @Override
    public boolean isVulnerable() {
        return this.vulnerableDuration > 0;
    }

    @Override
    public int getVulnerableDuration() {
        return this.vulnerableDuration;
    }

    @Override
    public void setVulnerableDuration(int duration) {
        this.vulnerableDuration = duration;
        LivingEntity livingEntity = this.getLivingEntity();
        if (!livingEntity.m_183503_().m_5776_()) {
            ConsecrationNetwork.syncVulnerability((Entity)livingEntity, duration);
        }
    }

    @Override
    public void decrementVulnerability() {
        if (this.vulnerableDuration > 0) {
            --this.vulnerableDuration;
        }
    }

    @Override
    public void readTag(CompoundTag tag) {
        this.setVulnerableDuration(tag.m_128451_(SMITE_TAG));
    }

    @Override
    public LivingEntity getLivingEntity() {
        return this.livingEntity;
    }

    @Override
    public CompoundTag writeTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(SMITE_TAG, this.getVulnerableDuration());
        return tag;
    }
}

