/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.capability;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.api.IUndying;
import top.theillusivec4.consecration.api.UndeadType;
import top.theillusivec4.consecration.api.VulnerabilityType;
import top.theillusivec4.consecration.common.ConsecrationConfig;
import top.theillusivec4.consecration.common.UndeadTypes;

public class UndyingCapability {
    public static final Capability<IUndying> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IUndying>(){});
    public static final ResourceLocation ID = new ResourceLocation("consecration", "undying");
    private static final Map<LivingEntity, LazyOptional<IUndying>> SERVER_CACHE = new HashMap<LivingEntity, LazyOptional<IUndying>>();
    private static final Map<LivingEntity, LazyOptional<IUndying>> CLIENT_CACHE = new HashMap<LivingEntity, LazyOptional<IUndying>>();

    private static Map<LivingEntity, LazyOptional<IUndying>> getCache(Level level) {
        return level.m_5776_() ? CLIENT_CACHE : SERVER_CACHE;
    }

    public static LazyOptional<IUndying> get(LivingEntity livingEntity) {
        if (!UndyingCapability.isUndying(livingEntity)) {
            return LazyOptional.empty();
        }
        Level level = livingEntity.m_183503_();
        Map<LivingEntity, LazyOptional<IUndying>> cache = UndyingCapability.getCache(level);
        LazyOptional optional = cache.get(livingEntity);
        if (optional == null) {
            optional = livingEntity.getCapability(INSTANCE);
            cache.put(livingEntity, (LazyOptional<IUndying>)optional);
            optional.addListener(self -> cache.remove(livingEntity));
        }
        return optional;
    }

    private static boolean isUndying(LivingEntity livingEntity) {
        return UndyingCapability.isValidCreature(livingEntity) && UndyingCapability.isValidDimension(livingEntity.m_20193_().m_46472_().m_135782_());
    }

    private static boolean isValidCreature(LivingEntity livingEntity) {
        return ConsecrationConfig.giveDefaultUndeadUndying && livingEntity.m_6336_() == MobType.f_21641_ || ConsecrationApi.getInstance().getUndeadType(livingEntity) != UndeadType.NOT;
    }

    private static boolean isValidDimension(ResourceLocation resourceLocation) {
        Set<ResourceLocation> dimensions = ConsecrationConfig.dimensions;
        ConsecrationConfig.PermissionMode permissionMode = ConsecrationConfig.dimensionsPermission;
        if (dimensions.isEmpty()) {
            return true;
        }
        if (permissionMode == ConsecrationConfig.PermissionMode.BLACKLIST) {
            return !dimensions.contains(resourceLocation);
        }
        return dimensions.contains(resourceLocation);
    }

    public static VulnerabilityType createVulnerability(LivingEntity target, DamageSource source) {
        UndeadType undeadType = UndeadTypes.get(target);
        ConsecrationApi consecration = ConsecrationApi.getInstance();
        if (undeadType == UndeadType.RESISTANT) {
            return VulnerabilityType.NONE;
        }
        if (!target.m_6095_().m_20672_() && source.m_19384_() && undeadType != UndeadType.FIRE_RESISTANT) {
            return VulnerabilityType.FIRE;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity damager = (LivingEntity)entity;
            ItemStack stack = damager.m_21205_();
            Item item = stack.m_41720_();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                Tier tier = tieredItem.m_43314_();
                for (ItemStack mat : tier.m_6282_().m_43908_()) {
                    ResourceLocation resourceLocation = mat.m_41720_().getRegistryName();
                    if (resourceLocation == null || !ConsecrationApi.getInstance().isHolyMaterial(resourceLocation.toString()) && !ConsecrationApi.getInstance().isHolyMaterial(resourceLocation.m_135815_())) continue;
                    return VulnerabilityType.HOLY;
                }
            }
            if (consecration.isHolyItem(stack)) {
                return VulnerabilityType.HOLY;
            }
            for (Enchantment enchantment : EnchantmentHelper.m_44831_((ItemStack)stack).keySet()) {
                if (!consecration.isHolyEnchantment(enchantment)) continue;
                return VulnerabilityType.HOLY;
            }
        }
        if (consecration.isHolyDamage(source.m_19385_()) || consecration.isHolyEntity(source.m_7640_()) || consecration.isHolyAttack(target, source)) {
            return VulnerabilityType.HOLY;
        }
        return VulnerabilityType.NONE;
    }
}

