/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.consecration.api.ConsecrationApi;

public record SPacketSetVulnerability(int entityId, int duration) {
    public static void encode(SPacketSetVulnerability msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.duration);
    }

    public static SPacketSetVulnerability decode(FriendlyByteBuf buf) {
        return new SPacketSetVulnerability(buf.readInt(), buf.readInt());
    }

    public static void handle(SPacketSetVulnerability msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(msg.entityId)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ConsecrationApi.getInstance().getUndying(livingEntity).ifPresent(undying -> undying.setVulnerableDuration(msg.duration));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

