/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.registry;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.consecration.common.effect.HolyEffect;
import top.theillusivec4.consecration.common.enchantment.UndeadProtection;
import top.theillusivec4.consecration.common.entity.FireArrowEntity;
import top.theillusivec4.consecration.common.item.FireArrowItem;
import top.theillusivec4.consecration.common.item.FireStickItem;

public class ConsecrationRegistry {
    private static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"consecration");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"consecration");
    private static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"consecration");
    private static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"consecration");
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"consecration");
    public static final RegistryObject<MobEffect> HOLY_EFFECT = EFFECTS.register("holy", HolyEffect::new);
    public static final RegistryObject<Item> FIRE_ARROW = ITEMS.register("fire_arrow", FireArrowItem::new);
    public static final RegistryObject<Item> FIRE_STICK = ITEMS.register("fire_stick", FireStickItem::new);
    public static final RegistryObject<Enchantment> UNDEAD_PROTECTION = ENCHANTMENTS.register("undead_protection", UndeadProtection::new);
    public static final RegistryObject<Potion> HOLY_POTION = POTIONS.register("holy", () -> new Potion("holy", new MobEffectInstance[]{new MobEffectInstance((MobEffect)HOLY_EFFECT.get(), 1, 0)}));
    public static final RegistryObject<Potion> STRONG_HOLY_POTION = POTIONS.register("strong_holy", () -> new Potion("holy", new MobEffectInstance[]{new MobEffectInstance((MobEffect)HOLY_EFFECT.get(), 1, 1)}));
    public static final RegistryObject<EntityType<FireArrowEntity>> FIRE_ARROW_TYPE = ENTITY_TYPES.register("fire_arrow", () -> EntityType.Builder.m_20704_(FireArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.3f).m_20719_().setTrackingRange(64).setUpdateInterval(5).setShouldReceiveVelocityUpdates(true).m_20712_("fire_arrow"));

    public static void setup(IEventBus eventBus) {
        EFFECTS.register(eventBus);
        ITEMS.register(eventBus);
        POTIONS.register(eventBus);
        ENCHANTMENTS.register(eventBus);
        ENTITY_TYPES.register(eventBus);
    }
}

