/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.common.impl;

import com.illusivesoulworks.consecration.api.ConsecrationApi;
import com.illusivesoulworks.consecration.api.IUndying;
import com.illusivesoulworks.consecration.api.UndeadType;
import com.illusivesoulworks.consecration.api.VulnerabilityType;
import com.illusivesoulworks.consecration.common.impl.HolySources;
import com.illusivesoulworks.consecration.common.impl.UndeadTypes;
import com.illusivesoulworks.consecration.platform.Services;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class ConsecrationApiImpl
extends ConsecrationApi {
    public static final ConsecrationApi INSTANCE = new ConsecrationApiImpl();

    @Override
    public String getModId() {
        return "consecration";
    }

    @Override
    public String getHolyIdentifier() {
        return "holy";
    }

    @Override
    public Optional<? extends IUndying> getUndying(LivingEntity livingEntity) {
        if (!UndeadTypes.isUndying(livingEntity)) {
            return Optional.empty();
        }
        return Services.CAPABILITY.getUndying(livingEntity);
    }

    @Override
    public boolean isHolyEntity(Entity entity) {
        return HolySources.contains(entity);
    }

    @Override
    public boolean isHolyItem(Item item) {
        return HolySources.contains(item);
    }

    @Override
    public boolean isHolyItem(ItemStack stack) {
        return this.isHolyItem(stack.m_41720_()) || Services.REGISTRY.canSmite(stack);
    }

    @Override
    public boolean isHolyEnchantment(Enchantment enchantment) {
        return HolySources.contains(enchantment);
    }

    @Override
    public boolean isHolyEffect(MobEffect mobEffect) {
        return HolySources.contains(mobEffect);
    }

    @Override
    public boolean isHolyDamage(String damageType) {
        return HolySources.containsDamage(damageType);
    }

    @Override
    public boolean isHolyMaterial(String material) {
        return HolySources.containsMaterial(material);
    }

    @Override
    public int getHolyProtectionLevel(LivingEntity attacker, LivingEntity livingEntity, DamageSource damageSource) {
        return HolySources.getHolyProtectionLevel(attacker, livingEntity, damageSource);
    }

    @Override
    public boolean isHolyAttack(LivingEntity livingEntity, DamageSource damageSource) {
        return HolySources.isHolyAttack(livingEntity, damageSource);
    }

    @Override
    public DamageSource causeHolyDamage(@Nonnull Entity entity) {
        return new EntityDamageSource("holy", entity).m_19389_();
    }

    @Override
    public DamageSource causeIndirectHolyDamage(@Nonnull Entity source, @Nullable Entity indirect) {
        return new IndirectEntityDamageSource("holy", source, indirect).m_19389_();
    }

    @Override
    public DamageSource causeHolyDamage() {
        return Services.REGISTRY.getDamageSource("holy").m_19389_();
    }

    @Override
    public VulnerabilityType getVulnerabilityType(LivingEntity livingEntity, DamageSource source) {
        UndeadType undeadType = UndeadTypes.getType(livingEntity);
        ConsecrationApi api = ConsecrationApi.getInstance();
        if (undeadType == UndeadType.RESISTANT) {
            return VulnerabilityType.NONE;
        }
        if (!livingEntity.m_6095_().m_20672_() && source.m_19384_() && undeadType != UndeadType.FIRE_RESISTANT) {
            return VulnerabilityType.FIRE;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity damager = (LivingEntity)entity;
            ItemStack stack = damager.m_21205_();
            Item item = stack.m_41720_();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                Tier tier = tieredItem.m_43314_();
                for (ItemStack mat : tier.m_6282_().m_43908_()) {
                    ResourceLocation resourceLocation = Services.REGISTRY.getKey(mat.m_41720_());
                    if (resourceLocation == null || !api.isHolyMaterial(resourceLocation.toString()) && !api.isHolyMaterial(resourceLocation.m_135815_())) continue;
                    return VulnerabilityType.HOLY;
                }
            }
            if (api.isHolyItem(stack)) {
                return VulnerabilityType.HOLY;
            }
            for (Enchantment enchantment : EnchantmentHelper.m_44831_((ItemStack)stack).keySet()) {
                if (!api.isHolyEnchantment(enchantment)) continue;
                return VulnerabilityType.HOLY;
            }
        }
        if (api.isHolyDamage(source.m_19385_()) || api.isHolyEntity(source.m_7640_()) || api.isHolyAttack(livingEntity, source)) {
            return VulnerabilityType.HOLY;
        }
        return VulnerabilityType.NONE;
    }

    @Override
    public UndeadType getUndeadType(LivingEntity livingEntity) {
        return UndeadTypes.getType(livingEntity);
    }
}

