/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.common.impl;

import com.illusivesoulworks.consecration.api.ConsecrationApi;
import com.illusivesoulworks.consecration.api.UndeadType;
import com.illusivesoulworks.consecration.common.config.ConsecrationConfig;
import com.illusivesoulworks.consecration.common.impl.UndeadTypes;
import com.illusivesoulworks.consecration.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;

public class HolySources {
    private static final Queue<BiFunction<LivingEntity, DamageSource, Boolean>> HOLY_ATTACKS = new ConcurrentLinkedQueue<BiFunction<LivingEntity, DamageSource, Boolean>>();
    private static final Queue<BiFunction<LivingEntity, DamageSource, Integer>> HOLY_PROTECTION = new ConcurrentLinkedQueue<BiFunction<LivingEntity, DamageSource, Integer>>();
    private static final Set<String> HOLY_DAMAGE = new HashSet<String>();
    private static final Set<String> HOLY_MATERIALS = new HashSet<String>();

    public static void reloadConfigs() {
        HOLY_DAMAGE.clear();
        HOLY_DAMAGE.addAll((Collection)ConsecrationConfig.CONFIG.holyDamage.get());
        HOLY_MATERIALS.clear();
        HOLY_MATERIALS.addAll((Collection)ConsecrationConfig.CONFIG.holyMaterials.get());
    }

    public static void addHolyAttack(BiFunction<LivingEntity, DamageSource, Boolean> func) {
        HOLY_ATTACKS.add(func);
    }

    public static void addHolyProtection(BiFunction<LivingEntity, DamageSource, Integer> func) {
        HOLY_PROTECTION.add(func);
    }

    public static boolean contains(Item item) {
        return Services.REGISTRY.isHolyTag(item);
    }

    public static boolean contains(MobEffect effect) {
        return Services.REGISTRY.isHolyTag(effect);
    }

    public static boolean contains(Enchantment enchantment) {
        return Services.REGISTRY.isHolyTag(enchantment);
    }

    public static boolean contains(Entity entity) {
        if (entity == null) {
            return false;
        }
        ArrayList effects = new ArrayList();
        if (entity instanceof ThrownPotion) {
            effects.addAll(PotionUtils.m_43547_((ItemStack)((ThrownPotion)entity).m_7846_()));
        } else if (entity instanceof AreaEffectCloud) {
            AreaEffectCloud cloud = (AreaEffectCloud)entity;
            effects.addAll(cloud.m_146791_().m_43488_());
        }
        for (MobEffectInstance effect : effects) {
            if (!HolySources.contains(effect.m_19544_())) continue;
            return true;
        }
        return Services.REGISTRY.isHolyTag(entity.m_6095_());
    }

    public static int getHolyProtectionLevel(LivingEntity attacker, LivingEntity defender, DamageSource damageSource) {
        if (UndeadTypes.getType(attacker) == UndeadType.RESISTANT) {
            return 0;
        }
        int level = 0;
        for (ItemStack itemStack : defender.m_6168_()) {
            if (itemStack.m_41619_()) continue;
            Item item = itemStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorMaterial material = ((ArmorItem)item).m_40401_();
                Ingredient ing = material.m_6230_();
                if (ing == null) continue;
                for (ItemStack mat : ing.m_43908_()) {
                    ResourceLocation resourceLocation = Services.REGISTRY.getKey(mat.m_41720_());
                    if (resourceLocation == null || !ConsecrationApi.getInstance().isHolyMaterial(resourceLocation.toString()) && !ConsecrationApi.getInstance().isHolyMaterial(resourceLocation.m_135815_())) continue;
                    ++level;
                }
                continue;
            }
            if (!ConsecrationApi.getInstance().isHolyItem(itemStack)) continue;
            ++level;
        }
        for (BiFunction biFunction : HOLY_PROTECTION) {
            level += ((Integer)biFunction.apply(defender, damageSource)).intValue();
        }
        return level;
    }

    public static boolean isHolyAttack(LivingEntity livingEntity, DamageSource damageSource) {
        for (BiFunction biFunction : HOLY_ATTACKS) {
            if (!((Boolean)biFunction.apply(livingEntity, damageSource)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMaterial(String material) {
        for (String holyMaterial : HOLY_MATERIALS) {
            String pattern = "(^|\\w*[_-])" + holyMaterial + "(\\b|[_-]\\w*)";
            if (!material.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDamage(String damage) {
        return HOLY_DAMAGE.contains(damage);
    }
}

