/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.platform.services;

import com.illusivesoulworks.consecration.api.UndeadType;
import com.illusivesoulworks.consecration.common.registry.RegistryObject;
import com.illusivesoulworks.consecration.common.registry.RegistryProvider;
import com.illusivesoulworks.consecration.platform.services.IRegistryService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class ForgeRegistryService
implements IRegistryService {
    private static final TagKey<EntityType<?>> UNDEAD = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).createOptionalTagKey(new ResourceLocation("consecration", "undead"), Set.of());
    private static final TagKey<EntityType<?>> FIRE_RESISTANT = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).createOptionalTagKey(new ResourceLocation("consecration", "fire_resistant"), Set.of());
    private static final TagKey<EntityType<?>> HOLY_RESISTANT = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).createOptionalTagKey(new ResourceLocation("consecration", "holy_resistant"), Set.of());
    private static final TagKey<EntityType<?>> RESISTANT = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).createOptionalTagKey(new ResourceLocation("consecration", "resistant"), Set.of());
    private static final TagKey<Item> HOLY_ITEMS = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).createOptionalTagKey(new ResourceLocation("consecration", "holy"), Set.of());
    private static final TagKey<MobEffect> HOLY_EFFECTS = Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.tags()).createOptionalTagKey(new ResourceLocation("consecration", "holy"), Set.of());
    private static final TagKey<Enchantment> HOLY_ENCHANTMENTS = Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.tags()).createOptionalTagKey(new ResourceLocation("consecration", "holy"), Set.of());
    private static final TagKey<EntityType<?>> HOLY_ENTITIES = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).createOptionalTagKey(new ResourceLocation("consecration", "holy"), Set.of());
    private static final ToolAction SMITE_ACTION = ToolAction.get((String)"smite");

    @Override
    public <T> RegistryProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        Optional containerOpt = ModList.get().getModContainerById(modId);
        if (containerOpt.isEmpty()) {
            throw new NullPointerException("Cannot find mod container for id " + modId);
        }
        ModContainer cont = (ModContainer)containerOpt.get();
        if (cont instanceof FMLModContainer) {
            FMLModContainer fmlModContainer = (FMLModContainer)cont;
            DeferredRegister register = DeferredRegister.create(resourceKey, (String)modId);
            register.register(fmlModContainer.getEventBus());
            return new Provider(modId, register);
        }
        throw new ClassCastException("The container of the mod " + modId + " is not a FML one!");
    }

    @Override
    public DamageSource getDamageSource(String id) {
        return new DamageSource(id);
    }

    @Override
    public void processUndeadTypes(BiConsumer<EntityType<?>, UndeadType> biConsumer) {
        ITagManager tagManager = ForgeRegistries.ENTITY_TYPES.tags();
        if (tagManager != null) {
            for (EntityType entity : ForgeRegistries.ENTITY_TYPES) {
                UndeadType type = UndeadType.NOT;
                if (tagManager.getTag(UNDEAD).contains((Object)entity)) {
                    type = UndeadType.DEFAULT;
                } else if (tagManager.getTag(FIRE_RESISTANT).contains((Object)entity)) {
                    type = UndeadType.FIRE_RESISTANT;
                } else if (tagManager.getTag(HOLY_RESISTANT).contains((Object)entity)) {
                    type = UndeadType.HOLY_RESISTANT;
                } else if (tagManager.getTag(RESISTANT).contains((Object)entity)) {
                    type = UndeadType.RESISTANT;
                }
                biConsumer.accept(entity, type);
            }
        }
    }

    @Override
    public ResourceLocation getKey(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    @Override
    public boolean isHolyTag(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(HOLY_ITEMS).contains((Object)item);
    }

    @Override
    public boolean isHolyTag(EntityType<?> entity) {
        return Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).getTag(HOLY_ENTITIES).contains(entity);
    }

    @Override
    public boolean isHolyTag(MobEffect mobEffect) {
        return Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.tags()).getTag(HOLY_EFFECTS).contains((Object)mobEffect);
    }

    @Override
    public boolean isHolyTag(Enchantment enchantment) {
        return Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.tags()).getTag(HOLY_ENCHANTMENTS).contains((Object)enchantment);
    }

    @Override
    public boolean canSmite(ItemStack stack) {
        return stack.canPerformAction(SMITE_ACTION);
    }

    private static class Provider<T>
    implements RegistryProvider<T> {
        private final String modId;
        private final DeferredRegister<T> registry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, DeferredRegister<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public String getModId() {
            return this.modId;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final net.minecraftforge.registries.RegistryObject obj = this.registry.register(name, supplier);
            RegistryObject ro = new RegistryObject<I>(){

                @Override
                public ResourceKey<I> getResourceKey() {
                    return obj.getKey();
                }

                @Override
                public ResourceLocation getId() {
                    return obj.getId();
                }

                @Override
                public I get() {
                    return obj.get();
                }

                @Override
                public Holder<I> asHolder() {
                    return (Holder)obj.getHolder().orElseThrow();
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Set<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }
    }
}

