/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration;

import com.illusivesoulworks.consecration.ConsecrationCommonMod;
import com.illusivesoulworks.consecration.api.ConsecrationImc;
import com.illusivesoulworks.consecration.api.IUndying;
import com.illusivesoulworks.consecration.common.ConsecrationEvents;
import com.illusivesoulworks.consecration.common.capability.UndyingCapability;
import com.illusivesoulworks.consecration.common.config.ConsecrationConfig;
import com.illusivesoulworks.consecration.common.impl.HolySources;
import com.illusivesoulworks.consecration.common.integration.AbstractCompatibilityModule;
import com.illusivesoulworks.consecration.common.integration.SilentGearModule;
import com.illusivesoulworks.consecration.common.integration.TetraModule;
import com.illusivesoulworks.consecration.common.integration.WerewolvesModule;
import com.illusivesoulworks.consecration.common.network.ConsecrationNetwork;
import com.illusivesoulworks.consecration.common.registry.ConsecrationRegistry;
import com.illusivesoulworks.consecration.common.trigger.SmiteTrigger;
import com.mojang.logging.LogUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.ItemHandlerHelper;
import org.slf4j.Logger;

@Mod(value="consecration")
public class ConsecrationForgeMod {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<String, Class<? extends AbstractCompatibilityModule>> MODULES = new HashMap<String, Class<? extends AbstractCompatibilityModule>>();
    public static final List<AbstractCompatibilityModule> ACTIVE_MODULES = new ArrayList<AbstractCompatibilityModule>();

    public ConsecrationForgeMod() {
        ConsecrationConfig.setup();
        ConsecrationCommonMod.setup();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::registerCaps);
        eventBus.addListener(this::imcEnqueue);
        eventBus.addListener(this::imcProcess);
        eventBus.addListener(this::creativeTab);
        MODULES.forEach((id, module) -> {
            if (ModList.get().isLoaded(id)) {
                try {
                    ACTIVE_MODULES.add((AbstractCompatibilityModule)module.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.error("Error adding module for mod " + id);
                }
            }
        });
    }

    private void setup(FMLCommonSetupEvent evt) {
        ConsecrationNetwork.setup();
        MinecraftForge.EVENT_BUS.register((Object)new UndyingCapability());
        MinecraftForge.EVENT_BUS.addListener(this::makeCampfireArrow);
        evt.enqueueWork(() -> {
            CriteriaTriggers.m_10595_((CriterionTrigger)SmiteTrigger.INSTANCE);
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43602_)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42436_}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ConsecrationRegistry.HOLY_POTION.get()));
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ConsecrationRegistry.HOLY_POTION.get())}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ConsecrationRegistry.STRONG_HOLY_POTION.get()));
        });
    }

    private void imcEnqueue(InterModEnqueueEvent evt) {
        ACTIVE_MODULES.forEach(AbstractCompatibilityModule::enqueueImc);
    }

    private void imcProcess(InterModProcessEvent evt) {
        evt.getIMCStream().forEach(imcMessage -> {
            Object message = imcMessage.messageSupplier().get();
            String method = imcMessage.method();
            if (message instanceof BiFunction) {
                if (method.equals(ConsecrationImc.HOLY_ATTACK.getId())) {
                    HolySources.addHolyAttack((BiFunction)message);
                } else if (method.equals(ConsecrationImc.HOLY_PROTECTION.getId())) {
                    HolySources.addHolyProtection((BiFunction)message);
                }
            }
        });
    }

    private void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.register(IUndying.class);
    }

    private void makeCampfireArrow(PlayerInteractEvent.RightClickBlock evt) {
        ConsecrationEvents.createCampfireArrow(evt.getEntity(), evt.getItemStack(), evt.getPos(), (player, stack) -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack, (int)player.m_150109_().f_35977_));
    }

    private void creativeTab(BuildCreativeModeTabContentsEvent evt) {
        ResourceKey tab = evt.getTabKey();
        if (tab == CreativeModeTabs.f_256797_) {
            evt.m_246326_((ItemLike)ConsecrationRegistry.FIRE_STICK.get());
            evt.m_246326_((ItemLike)ConsecrationRegistry.FIRE_ARROW.get());
        }
    }

    static {
        MODULES.put("tetra", TetraModule.class);
        MODULES.put("werewolves", WerewolvesModule.class);
        MODULES.put("silentgear", SilentGearModule.class);
    }
}

