/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.common.impl;

import com.illusivesoulworks.consecration.api.UndeadType;
import com.illusivesoulworks.consecration.common.config.ConsecrationConfig;
import com.illusivesoulworks.consecration.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;

public class UndeadTypes {
    private static final Map<EntityType<?>, UndeadType> TYPE_TO_UNDEAD_TYPE = new HashMap();
    private static boolean initialized = false;

    public static void init() {
        TYPE_TO_UNDEAD_TYPE.clear();
        Services.REGISTRY.processUndeadTypes(TYPE_TO_UNDEAD_TYPE::put);
        initialized = true;
    }

    public static UndeadType getType(LivingEntity livingEntity) {
        if (!initialized) {
            UndeadTypes.init();
        }
        return TYPE_TO_UNDEAD_TYPE.getOrDefault(livingEntity.m_6095_(), UndeadType.NOT);
    }

    public static boolean isUndying(LivingEntity livingEntity) {
        return UndeadTypes.isValidCreature(livingEntity) && UndeadTypes.isValidDimension(livingEntity.m_9236_().m_46472_().m_135782_());
    }

    private static boolean isValidCreature(LivingEntity livingEntity) {
        return (Boolean)ConsecrationConfig.CONFIG.giveDefaultUndeadUndying.get() != false && livingEntity.m_6336_() == MobType.f_21641_ || UndeadTypes.getType(livingEntity) != UndeadType.NOT;
    }

    private static boolean isValidDimension(ResourceLocation resourceLocation) {
        Set dimensions = ((List)ConsecrationConfig.CONFIG.dimensionsList.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        ConsecrationConfig.ListType listType = (ConsecrationConfig.ListType)((Object)ConsecrationConfig.CONFIG.dimensionsListType.get());
        if (dimensions.isEmpty()) {
            return true;
        }
        if (listType == ConsecrationConfig.ListType.DENY) {
            return !dimensions.contains(resourceLocation);
        }
        return dimensions.contains(resourceLocation);
    }
}

