/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.common.impl;

import com.illusivesoulworks.consecration.api.ConsecrationApi;
import com.illusivesoulworks.consecration.api.IUndying;
import com.illusivesoulworks.consecration.api.VulnerabilityType;
import com.illusivesoulworks.consecration.common.config.ConsecrationConfig;
import com.illusivesoulworks.consecration.common.trigger.SmiteTrigger;
import com.illusivesoulworks.consecration.platform.Services;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class Undying
implements IUndying {
    private static final String SMITE_TAG = "smite";
    private static final UUID SPEED_MOD = UUID.fromString("b812ef3d-0ef9-4368-845b-fad7003a1f4f");
    private final LivingEntity livingEntity;
    private int vulnerableDuration = 0;

    public Undying(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
    }

    @Override
    public void tick() {
        if (!this.livingEntity.m_9236_().m_5776_()) {
            if (this.livingEntity.f_19797_ % 20 == 0) {
                AttributeInstance speedAttribute = this.livingEntity.m_21051_(Attributes.f_22279_);
                if (speedAttribute != null) {
                    speedAttribute.m_22120_(SPEED_MOD);
                }
                if (this.isVulnerable()) {
                    --this.vulnerableDuration;
                } else {
                    double speedMod;
                    if (this.livingEntity.m_21223_() < this.livingEntity.m_21233_()) {
                        this.livingEntity.m_5634_((float)((Integer)ConsecrationConfig.CONFIG.healthRegeneration.get()).intValue());
                    }
                    if ((speedMod = (double)((Integer)ConsecrationConfig.CONFIG.speedModifier.get()).intValue() / 100.0) > 0.0 && speedAttribute != null && speedAttribute.m_22111_(SPEED_MOD) == null) {
                        speedAttribute.m_22118_(new AttributeModifier(SPEED_MOD, "Undying speed", speedMod, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                }
            }
        } else if (this.isVulnerable()) {
            this.livingEntity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123751_, this.livingEntity.m_20182_().f_82479_ + (this.livingEntity.m_217043_().m_188500_() - 0.5) * (double)this.livingEntity.m_20205_(), this.livingEntity.m_20182_().f_82480_ + this.livingEntity.m_217043_().m_188500_() * (double)this.livingEntity.m_20206_(), this.livingEntity.m_20182_().f_82481_ + (this.livingEntity.m_217043_().m_188500_() - 0.5) * (double)this.livingEntity.m_20205_(), 0.0, 0.0, 0.0);
            if (this.livingEntity.f_19797_ % 20 == 0) {
                --this.vulnerableDuration;
            }
        }
    }

    @Override
    public boolean isVulnerable() {
        return this.vulnerableDuration > 0;
    }

    @Override
    public int getVulnerableDuration() {
        return this.vulnerableDuration;
    }

    @Override
    public void setVulnerableDuration(int duration) {
        this.vulnerableDuration = duration;
        this.sync();
    }

    @Override
    public void onEffectAdded(MobEffectInstance effectInstance) {
        if (!this.livingEntity.m_9236_().m_5776_()) {
            ConsecrationApi api = ConsecrationApi.getInstance();
            api.getUndying(this.livingEntity).ifPresent(undying -> {
                MobEffect effect = effectInstance.m_19544_();
                if (api.isHolyEffect(effect)) {
                    int duration = effect.m_8093_() ? ((Integer)ConsecrationConfig.CONFIG.holyVulnerableDuration.get()).intValue() : effectInstance.m_19557_();
                    undying.setVulnerableDuration(duration);
                }
            });
        }
    }

    @Override
    public float onDamaged(DamageSource source, float damage) {
        Entity trueSource;
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return damage;
        }
        VulnerabilityType type = ConsecrationApi.getInstance().getVulnerabilityType(this.livingEntity, source);
        if (type != VulnerabilityType.NONE) {
            if (type == VulnerabilityType.FIRE) {
                this.setVulnerableDuration((Integer)ConsecrationConfig.CONFIG.fireVulnerableDuration.get());
            } else {
                this.setVulnerableDuration((Integer)ConsecrationConfig.CONFIG.holyVulnerableDuration.get());
            }
            if (source.m_7639_() instanceof ServerPlayer) {
                SmiteTrigger.INSTANCE.trigger((ServerPlayer)source.m_7639_());
            }
        } else if (!source.m_269533_(DamageTypeTags.f_268630_) && !this.isVulnerable() && (trueSource = source.m_7639_()) != null) {
            if (trueSource instanceof Player) {
                return damage * (1.0f - (float)((Integer)ConsecrationConfig.CONFIG.damageReduction.get()).intValue() / 100.0f);
            }
            if (trueSource instanceof LivingEntity) {
                return damage * (1.0f - (float)((Integer)ConsecrationConfig.CONFIG.damageReductionVsMobs.get()).intValue() / 100.0f);
            }
        }
        return damage;
    }

    @Override
    public void sync() {
        if (!this.livingEntity.m_9236_().m_5776_()) {
            Services.NETWORK.sendVulnerabilitySyncS2C(this.livingEntity, this.vulnerableDuration);
        }
    }

    @Override
    public void readTag(CompoundTag tag) {
        this.setVulnerableDuration(tag.m_128451_(SMITE_TAG));
    }

    @Override
    public LivingEntity getLivingEntity() {
        return this.livingEntity;
    }

    @Override
    public CompoundTag writeTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(SMITE_TAG, this.getVulnerableDuration());
        return tag;
    }
}

