/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.common.impl;

import com.illusivesoulworks.consecration.api.ConsecrationApi;
import com.illusivesoulworks.consecration.api.IUndying;
import com.illusivesoulworks.consecration.api.UndeadType;
import com.illusivesoulworks.consecration.api.VulnerabilityType;
import com.illusivesoulworks.consecration.common.impl.HolySources;
import com.illusivesoulworks.consecration.common.impl.UndeadTypes;
import com.illusivesoulworks.consecration.platform.Services;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1285;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2960;

public class ConsecrationApiImpl
extends ConsecrationApi {
    public static final ConsecrationApi INSTANCE = new ConsecrationApiImpl();

    @Override
    public String getModId() {
        return "consecration";
    }

    @Override
    public String getHolyIdentifier() {
        return "holy";
    }

    @Override
    public Optional<? extends IUndying> getUndying(class_1309 livingEntity) {
        if (!UndeadTypes.isUndying(livingEntity)) {
            return Optional.empty();
        }
        return Services.CAPABILITY.getUndying(livingEntity);
    }

    @Override
    public boolean isHolyEntity(class_1297 entity) {
        return HolySources.contains(entity);
    }

    @Override
    public boolean isHolyItem(class_1792 item) {
        return HolySources.contains(item);
    }

    @Override
    public boolean isHolyItem(class_1799 stack) {
        return this.isHolyItem(stack.method_7909()) || Services.REGISTRY.canSmite(stack);
    }

    @Override
    public boolean isHolyEnchantment(class_1887 enchantment) {
        return HolySources.contains(enchantment);
    }

    @Override
    public boolean isHolyEffect(class_1291 mobEffect) {
        return HolySources.contains(mobEffect);
    }

    @Override
    public boolean isHolyDamage(String damageType) {
        return HolySources.containsDamage(damageType);
    }

    @Override
    public boolean isHolyMaterial(String material) {
        return HolySources.containsMaterial(material);
    }

    @Override
    public int getHolyProtectionLevel(class_1309 attacker, class_1309 livingEntity, class_1282 damageSource) {
        return HolySources.getHolyProtectionLevel(attacker, livingEntity, damageSource);
    }

    @Override
    public boolean isHolyAttack(class_1309 livingEntity, class_1282 damageSource) {
        return HolySources.isHolyAttack(livingEntity, damageSource);
    }

    @Override
    public class_1282 causeHolyDamage(@Nonnull class_1297 entity) {
        return new class_1285("holy", entity).method_5515();
    }

    @Override
    public class_1282 causeIndirectHolyDamage(@Nonnull class_1297 source, @Nullable class_1297 indirect) {
        return new class_1284("holy", source, indirect).method_5515();
    }

    @Override
    public class_1282 causeHolyDamage() {
        return Services.REGISTRY.getDamageSource("holy").method_5515();
    }

    @Override
    public VulnerabilityType getVulnerabilityType(class_1309 livingEntity, class_1282 source) {
        UndeadType undeadType = UndeadTypes.getType(livingEntity);
        ConsecrationApi api = ConsecrationApi.getInstance();
        if (undeadType == UndeadType.RESISTANT) {
            return VulnerabilityType.NONE;
        }
        if (!livingEntity.method_5864().method_19946() && source.method_5534() && undeadType != UndeadType.FIRE_RESISTANT) {
            return VulnerabilityType.FIRE;
        }
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1309) {
            class_1309 damager = (class_1309)class_12972;
            class_1799 stack = damager.method_6047();
            class_1792 item = stack.method_7909();
            if (item instanceof class_1831) {
                class_1831 tieredItem = (class_1831)item;
                class_1832 tier = tieredItem.method_8022();
                for (class_1799 mat : tier.method_8023().method_8105()) {
                    class_2960 resourceLocation = Services.REGISTRY.getKey(mat.method_7909());
                    if (resourceLocation == null || !api.isHolyMaterial(resourceLocation.toString()) && !api.isHolyMaterial(resourceLocation.method_12832())) continue;
                    return VulnerabilityType.HOLY;
                }
            }
            if (api.isHolyItem(stack)) {
                return VulnerabilityType.HOLY;
            }
            for (class_1887 enchantment : class_1890.method_8222((class_1799)stack).keySet()) {
                if (!api.isHolyEnchantment(enchantment)) continue;
                return VulnerabilityType.HOLY;
            }
        }
        if (api.isHolyDamage(source.method_5525()) || api.isHolyEntity(source.method_5526()) || api.isHolyAttack(livingEntity, source)) {
            return VulnerabilityType.HOLY;
        }
        return VulnerabilityType.NONE;
    }

    @Override
    public UndeadType getUndeadType(class_1309 livingEntity) {
        return UndeadTypes.getType(livingEntity);
    }
}

