/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.common.impl;

import com.illusivesoulworks.consecration.api.ConsecrationApi;
import com.illusivesoulworks.consecration.api.IUndying;
import com.illusivesoulworks.consecration.api.VulnerabilityType;
import com.illusivesoulworks.consecration.common.config.ConsecrationConfig;
import com.illusivesoulworks.consecration.common.trigger.SmiteTrigger;
import com.illusivesoulworks.consecration.platform.Services;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class Undying
implements IUndying {
    private static final String SMITE_TAG = "smite";
    private static final UUID SPEED_MOD = UUID.fromString("b812ef3d-0ef9-4368-845b-fad7003a1f4f");
    private final class_1309 livingEntity;
    private int vulnerableDuration = 0;

    public Undying(class_1309 livingEntity) {
        this.livingEntity = livingEntity;
    }

    @Override
    public void tick() {
        if (!this.livingEntity.method_37908().method_8608()) {
            if (this.livingEntity.field_6012 % 20 == 0) {
                class_1324 speedAttribute = this.livingEntity.method_5996(class_5134.field_23719);
                if (speedAttribute != null) {
                    speedAttribute.method_6200(SPEED_MOD);
                }
                if (this.isVulnerable()) {
                    --this.vulnerableDuration;
                } else {
                    double speedMod;
                    if (this.livingEntity.method_6032() < this.livingEntity.method_6063()) {
                        this.livingEntity.method_6025((float)((Integer)ConsecrationConfig.CONFIG.healthRegeneration.get()).intValue());
                    }
                    if ((speedMod = (double)((Integer)ConsecrationConfig.CONFIG.speedModifier.get()).intValue() / 100.0) > 0.0 && speedAttribute != null && speedAttribute.method_6199(SPEED_MOD) == null) {
                        speedAttribute.method_26835(new class_1322(SPEED_MOD, "Undying speed", speedMod, class_1322.class_1323.field_6331));
                    }
                }
            }
        } else if (this.isVulnerable()) {
            this.livingEntity.method_37908().method_8406((class_2394)class_2398.field_11213, this.livingEntity.method_19538().field_1352 + (this.livingEntity.method_6051().method_43058() - 0.5) * (double)this.livingEntity.method_17681(), this.livingEntity.method_19538().field_1351 + this.livingEntity.method_6051().method_43058() * (double)this.livingEntity.method_17682(), this.livingEntity.method_19538().field_1350 + (this.livingEntity.method_6051().method_43058() - 0.5) * (double)this.livingEntity.method_17681(), 0.0, 0.0, 0.0);
            if (this.livingEntity.field_6012 % 20 == 0) {
                --this.vulnerableDuration;
            }
        }
    }

    @Override
    public boolean isVulnerable() {
        return this.vulnerableDuration > 0;
    }

    @Override
    public int getVulnerableDuration() {
        return this.vulnerableDuration;
    }

    @Override
    public void setVulnerableDuration(int duration) {
        this.vulnerableDuration = duration;
        this.sync();
    }

    @Override
    public void onEffectAdded(class_1293 effectInstance) {
        if (!this.livingEntity.method_37908().method_8608()) {
            ConsecrationApi api = ConsecrationApi.getInstance();
            api.getUndying(this.livingEntity).ifPresent(undying -> {
                class_1291 effect = effectInstance.method_5579();
                if (api.isHolyEffect(effect)) {
                    int duration = effect.method_5561() ? ((Integer)ConsecrationConfig.CONFIG.holyVulnerableDuration.get()).intValue() : effectInstance.method_5584();
                    undying.setVulnerableDuration(duration);
                }
            });
        }
    }

    @Override
    public float onDamaged(class_1282 source, float damage) {
        class_1297 trueSource;
        if (source == class_1282.field_5849 || source == class_1282.field_5844 || source == class_1282.field_5855) {
            return damage;
        }
        VulnerabilityType type = ConsecrationApi.getInstance().getVulnerabilityType(this.livingEntity, source);
        if (type != VulnerabilityType.NONE) {
            if (type == VulnerabilityType.FIRE) {
                this.setVulnerableDuration((Integer)ConsecrationConfig.CONFIG.fireVulnerableDuration.get());
            } else {
                this.setVulnerableDuration((Integer)ConsecrationConfig.CONFIG.holyVulnerableDuration.get());
            }
            if (source.method_5529() instanceof class_3222) {
                SmiteTrigger.INSTANCE.trigger((class_3222)source.method_5529());
            }
        } else if (!source.method_5504() && !this.isVulnerable() && (trueSource = source.method_5529()) != null) {
            if (trueSource instanceof class_1657) {
                return damage * (1.0f - (float)((Integer)ConsecrationConfig.CONFIG.damageReduction.get()).intValue() / 100.0f);
            }
            if (trueSource instanceof class_1309) {
                return damage * (1.0f - (float)((Integer)ConsecrationConfig.CONFIG.damageReductionVsMobs.get()).intValue() / 100.0f);
            }
        }
        return damage;
    }

    @Override
    public void sync() {
        if (!this.livingEntity.method_37908().method_8608()) {
            Services.NETWORK.sendVulnerabilitySyncS2C(this.livingEntity, this.vulnerableDuration);
        }
    }

    @Override
    public void readTag(class_2487 tag) {
        this.setVulnerableDuration(tag.method_10550(SMITE_TAG));
    }

    @Override
    public class_1309 getLivingEntity() {
        return this.livingEntity;
    }

    @Override
    public class_2487 writeTag() {
        class_2487 tag = new class_2487();
        tag.method_10569(SMITE_TAG, this.getVulnerableDuration());
        return tag;
    }
}

