/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.platform;

import com.illusivesoulworks.consecration.api.UndeadType;
import com.illusivesoulworks.consecration.common.registry.RegistryObject;
import com.illusivesoulworks.consecration.common.registry.RegistryProvider;
import com.illusivesoulworks.consecration.platform.services.IRegistryService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class QuiltRegistryService
implements IRegistryService {
    public static final class_6862<class_1299<?>> UNDEAD = class_6862.method_40092((class_5321)class_2378.field_25107, (class_2960)new class_2960("consecration", "undead"));
    public static final class_6862<class_1299<?>> FIRE_RESISTANT = class_6862.method_40092((class_5321)class_2378.field_25107, (class_2960)new class_2960("consecration", "fire_resistant"));
    public static final class_6862<class_1299<?>> HOLY_RESISTANT = class_6862.method_40092((class_5321)class_2378.field_25107, (class_2960)new class_2960("consecration", "holy_resistant"));
    public static final class_6862<class_1299<?>> RESISTANT = class_6862.method_40092((class_5321)class_2378.field_25107, (class_2960)new class_2960("consecration", "resistant"));
    public static final class_6862<class_1792> HOLY_ITEMS = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960("consecration", "holy"));
    public static final class_6862<class_1291> HOLY_EFFECTS = class_6862.method_40092((class_5321)class_2378.field_25104, (class_2960)new class_2960("consecration", "holy"));
    public static final class_6862<class_1887> HOLY_ENCHANTMENTS = class_6862.method_40092((class_5321)class_2378.field_25106, (class_2960)new class_2960("consecration", "holy"));
    public static final class_6862<class_1299<?>> HOLY_ENTITIES = class_6862.method_40092((class_5321)class_2378.field_25107, (class_2960)new class_2960("consecration", "holy"));

    @Override
    public class_1282 getDamageSource(String holy) {
        return new class_1282(holy);
    }

    @Override
    public void processUndeadTypes(BiConsumer<class_1299<?>, UndeadType> biConsumer) {
        for (class_1299 entity : class_2378.field_11145.method_10220().toList()) {
            UndeadType type = UndeadType.NOT;
            if (entity.method_20210(UNDEAD)) {
                type = UndeadType.DEFAULT;
            } else if (entity.method_20210(FIRE_RESISTANT)) {
                type = UndeadType.FIRE_RESISTANT;
            } else if (entity.method_20210(HOLY_RESISTANT)) {
                type = UndeadType.HOLY_RESISTANT;
            } else if (entity.method_20210(RESISTANT)) {
                type = UndeadType.RESISTANT;
            }
            biConsumer.accept(entity, type);
        }
    }

    @Override
    public class_2960 getKey(class_1792 item) {
        return class_2378.field_11142.method_10221((Object)item);
    }

    @Override
    public boolean isHolyTag(class_1792 item) {
        return item.method_7854().method_31573(HOLY_ITEMS);
    }

    @Override
    public boolean isHolyTag(class_1299<?> entity) {
        return entity.method_20210(HOLY_ENTITIES);
    }

    @Override
    public boolean isHolyTag(class_1291 mobEffect) {
        return class_2378.field_11159.method_40266(HOLY_EFFECTS).map(holders -> holders.method_40239().anyMatch(mobEffectHolder -> mobEffectHolder.comp_349() == mobEffect)).orElse(false);
    }

    @Override
    public boolean isHolyTag(class_1887 enchantment) {
        return class_2378.field_11160.method_40266(HOLY_ENCHANTMENTS).map(holders -> holders.method_40239().anyMatch(enchantmentHolder -> enchantmentHolder.comp_349() == enchantment)).orElse(false);
    }

    @Override
    public boolean canSmite(class_1799 stack) {
        return false;
    }

    @Override
    public <T> RegistryProvider<T> create(class_5321<? extends class_2378<T>> resourceKey, String modId) {
        return new Provider(modId, resourceKey);
    }

    @Override
    public <T> RegistryProvider<T> create(class_2378<T> registry, String modId) {
        return new Provider<T>(modId, registry);
    }

    private static class Provider<T>
    implements RegistryProvider<T> {
        private final String modId;
        private final class_2378<T> registry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, class_5321<? extends class_2378<T>> key) {
            this.modId = modId;
            class_2378 reg = (class_2378)class_2378.field_11144.method_10223(key.method_29177());
            if (reg == null) {
                throw new RuntimeException("Registry with name " + key.method_29177() + " was not found!");
            }
            this.registry = reg;
        }

        private Provider(String modId, class_2378<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final class_2960 rl = new class_2960(this.modId, name);
            final Object obj = class_2378.method_10230(this.registry, (class_2960)rl, supplier.get());
            RegistryObject ro = new RegistryObject<I>(){
                final class_5321<I> key;
                {
                    this.key = class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)rl);
                }

                @Override
                public class_5321<I> getResourceKey() {
                    return this.key;
                }

                @Override
                public class_2960 getId() {
                    return rl;
                }

                @Override
                public I get() {
                    return obj;
                }

                @Override
                public class_6880<I> asHolder() {
                    return (class_6880)registry.method_40268(this.key);
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Collection<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }
}

