/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.common.config;

import com.illusivesoulworks.consecration.common.impl.HolySources;
import com.illusivesoulworks.spectrelib.config.SpectreConfig;
import com.illusivesoulworks.spectrelib.config.SpectreConfigLoader;
import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class ConsecrationConfig {
    public static final SpectreConfigSpec CONFIG_SPEC;
    public static final Config CONFIG;
    private static final String CONFIG_PREFIX = "gui.consecration.config.";

    public static void setup() {
        SpectreConfig config = SpectreConfigLoader.add((SpectreConfig.Type)SpectreConfig.Type.SERVER, (SpectreConfigSpec)CONFIG_SPEC, (String)"consecration");
        config.addLoadListener((cfg, flag) -> HolySources.reloadConfigs());
    }

    static {
        Pair specPair = new SpectreConfigSpec.Builder().configure(Config::new);
        CONFIG_SPEC = (SpectreConfigSpec)specPair.getRight();
        CONFIG = (Config)specPair.getLeft();
    }

    public static class Config {
        public final SpectreConfigSpec.ConfigValue<List<? extends String>> dimensionsList;
        public final SpectreConfigSpec.EnumValue<ListType> dimensionsListType;
        public final SpectreConfigSpec.IntValue fireVulnerableDuration;
        public final SpectreConfigSpec.IntValue holyVulnerableDuration;
        public final SpectreConfigSpec.ConfigValue<List<? extends String>> holyMaterials;
        public final SpectreConfigSpec.BooleanValue giveDefaultUndeadUndying;
        public final SpectreConfigSpec.IntValue damageReduction;
        public final SpectreConfigSpec.IntValue healthRegeneration;
        public final SpectreConfigSpec.IntValue speedModifier;
        public final SpectreConfigSpec.IntValue damageReductionVsMobs;

        public Config(SpectreConfigSpec.Builder builder) {
            builder.push("dimension");
            this.dimensionsList = builder.comment("Dimensions for empowered undead.").translation("gui.consecration.config.dimensionsList").defineList("dimensionsList", ArrayList::new, s -> s instanceof String);
            this.dimensionsListType = builder.comment("Determines if dimensionsList contains allowed dimensions or denied dimensions.").translation("gui.consecration.config.dimensionsListType").defineEnum("dimensionsListType", (Enum)ListType.DENY);
            builder.pop();
            builder.push("vulnerability");
            this.fireVulnerableDuration = builder.comment("The number of seconds that vulnerability from fire lasts.").translation("gui.consecration.config.fireVulnerableDuration").defineInRange("fireVulnerableDuration", 10, 0, 100);
            this.holyVulnerableDuration = builder.comment("The number of seconds that vulnerability from holy sources lasts.").translation("gui.consecration.config.holyVulnerableDuration").defineInRange("holyVulnerableDuration", 10, 0, 100);
            this.holyMaterials = builder.comment("The materials that will be considered holy.").translation("gui.consecration.config.holyMaterials").defineList("holyMaterials", Collections.singletonList("silver"), s -> s instanceof String);
            builder.pop();
            builder.push("undying");
            this.giveDefaultUndeadUndying = builder.comment("If enabled, default undead creatures will be given the undying trait.").translation("gui.consecration.config.giveDefaultUndeadUndying").define("giveDefaultUndeadUndying", true);
            this.damageReduction = builder.comment("The percent damage reduction against non-vulnerable damage.").translation("gui.consecration.config.damageReduction").defineInRange("damageReduction", 80, 0, 100);
            this.healthRegeneration = builder.comment("The undying natural health regeneration in half-hearts per second.").translation("gui.consecration.config.healthRegeneration").defineInRange("healthRegeneration", 1, 0, 1000);
            this.speedModifier = builder.comment("The undying bonus speed modifier as a percent increase.").translation("gui.consecration.config.speedModifier").defineInRange("speedModifier", 0, 0, 1000);
            this.damageReductionVsMobs = builder.comment("The percent damage reduction against non-vulnerable damage dealt by mobs.").translation("gui.consecration.config.damageReductionVsMobs").defineInRange("damageReductionVsMobs", 80, 0, 100);
            builder.pop();
        }
    }

    public static enum ListType {
        DENY,
        ALLOW;

    }
}

