/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon;

import chrono.mods.compassribbon.CompassRibbonCommands;
import chrono.mods.compassribbon.config.CompassRibbonConfig;
import chrono.mods.compassribbon.config.ConfigManager;
import chrono.mods.compassribbon.helpers.GameRenderAccessor;
import chrono.mods.compassribbon.helpers.MapInfo;
import chrono.mods.compassribbon.helpers.MapMarker;
import chrono.mods.compassribbon.helpers.RibbonMapMarker;
import chrono.mods.compassribbon.helpers.RibbonMarker;
import chrono.mods.compassribbon.helpers.RibbonModMarker;
import chrono.mods.compassribbon.network.ClientNetworkHandler;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1759;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1800;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_5272;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompassRibbonClient
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"CompassRibbon");
    public static final ConfigManager<CompassRibbonConfig> CONFIG_MANAGER = new ConfigManager<CompassRibbonConfig>("cr-compass-ribbon", CompassRibbonConfig.class, "CompassRibbon|Config");
    private static final List<String> DIRECTION = Arrays.asList("S", "SW", "W", "NW", "N", "NE", "E", "SE");
    private static final int RIBBON_Y_POS = 2;
    private static final int RIBBON_HEIGHT = 10;

    public void onInitializeClient() {
        ClientNetworkHandler.init();
        CompassRibbonCommands.init();
    }

    public static void onRender(class_4587 matrixStack, float tickDelta) {
        boolean showDirections;
        class_310 client = class_310.method_1551();
        if (client.field_1690.field_1866) {
            return;
        }
        CompassRibbonConfig config = CONFIG_MANAGER.getConfig();
        if (!CompassRibbonClient.inventoryContainsItem(client, ((CompassRibbonConfig.CompassSlot)((Object)config.directionsCompassSlot.getValue())).getSlot(), class_1802.field_8251)) {
            return;
        }
        class_746 player = client.field_1724;
        List<RibbonMarker> markers = CompassRibbonClient.getMarkersInRange(client, config);
        boolean showMapMarkers = !config.mapMarkersOpacity.isTransparent();
        boolean bl = showDirections = !config.directionsOpacity.isTransparent();
        if (showDirections && player.field_6002.method_27983() == class_1937.field_25180) {
            if (config.directionsInNether.getValue() == CompassRibbonConfig.DirectionsVisibility.HIDDEN) {
                showDirections = false;
            }
        } else if (showDirections && player.field_6002.method_27983() == class_1937.field_25181 && config.directionsInEnd.getValue() == CompassRibbonConfig.DirectionsVisibility.HIDDEN) {
            showDirections = false;
        }
        if (!showDirections && !showMapMarkers) {
            return;
        }
        int windowWidth = client.method_22683().method_4486();
        int windowHeight = client.method_22683().method_4502();
        int windowCenterX = windowWidth / 2;
        int ribbonWidth = windowWidth * (Integer)config.ribbonWidth.getValue() / 100;
        RenderSystem.disableAlphaTest();
        if (showDirections || !config.mapMarkersOpacity.isTransparent()) {
            int alpha = CompassRibbonClient.opacityToAlpha(config.directionsOpacity.getValue());
            class_332.method_25294((class_4587)matrixStack, (int)windowCenterX, (int)0, (int)(windowCenterX + 1), (int)2, (int)(0xFFFFFF + alpha));
            class_332.method_25294((class_4587)matrixStack, (int)windowCenterX, (int)12, (int)(windowCenterX + 1), (int)14, (int)(0xFFFFFF + alpha));
        }
        double ribbonRange = ((Integer)config.ribbonRange.getValue()).intValue();
        if (!config.fovHighlightOpacity.isTransparent()) {
            double windowAspectRatio = (double)windowWidth / (double)windowHeight;
            double verticalFov = ((GameRenderAccessor)client.field_1773).cr$getFov(tickDelta);
            double horizontalFov = Math.atan(Math.tan(verticalFov / 360.0 * Math.PI) * windowAspectRatio) / Math.PI * 360.0;
            int halfWidth = (int)(Math.min(1.0, horizontalFov / ribbonRange) * (double)ribbonWidth / 2.0);
            class_332.method_25294((class_4587)matrixStack, (int)(windowCenterX - halfWidth), (int)2, (int)(windowCenterX + halfWidth), (int)12, (int)(((CompassRibbonConfig.FovHighlightColor)((Object)config.fovHighlightColor.getValue())).getColor() + CompassRibbonClient.opacityToAlpha(config.fovHighlightOpacity.getValue())));
        }
        if (showDirections) {
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            double ribbonAngle = CompassRibbonClient.getRibbonAngle(player, config);
            double ribbonStartAngle = ribbonAngle - ribbonRange / 2.0;
            double ribbonEndAngle = ribbonStartAngle + ribbonRange;
            for (double angle = (double)class_3532.method_15384((double)(ribbonStartAngle / 45.0)) * 45.0; angle <= ribbonEndAngle; angle += 45.0) {
                String direction = CompassRibbonClient.angleToDirection((float)angle);
                double position = class_3532.method_15338((double)(angle - ribbonAngle)) / ribbonRange;
                int color = direction.length() == 1 ? ((CompassRibbonConfig.DirectionsColor)((Object)config.directionsColor.getValue())).getColor1() : ((CompassRibbonConfig.DirectionsColor)((Object)config.directionsColor.getValue())).getColor2();
                CompassRibbonClient.drawDirection(client, matrixStack, direction, windowCenterX + (int)(position * (double)ribbonWidth), 4, color, (int)((float)config.directionsOpacity.getValue().intValue() * CompassRibbonClient.positionToAlpha((float)position)));
            }
            RenderSystem.disableBlend();
            RenderSystem.popMatrix();
        }
        if (showMapMarkers && !markers.isEmpty()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523, (class_4493.class_4535)class_4493.class_4535.field_22534, (class_4493.class_4534)class_4493.class_4534.field_22527);
            double scale = client.method_22683().method_4495();
            RenderSystem.enableScissor((int)0, (int)(client.method_22683().method_4507() - (int)(12.0 * scale)), (int)client.method_22683().method_4480(), (int)((int)(10.0 * scale)));
            int z = 1;
            for (RibbonMarker marker : markers) {
                double markerPosition = marker.getYaw() / ribbonRange;
                int x = windowCenterX + (int)Math.round(markerPosition * (double)ribbonWidth);
                int verticalOffset = (int)Math.max(marker.getPitch() / 15.0, -3.0);
                CompassRibbonClient.drawMarker(client, x, 2 + verticalOffset, z++, marker, (int)((float)config.mapMarkersOpacity.getValue().intValue() * CompassRibbonClient.positionToAlpha((float)markerPosition) * CompassRibbonClient.distanceToAlpha((float)marker.getDistance())));
            }
            RenderSystem.disableScissor();
            RenderSystem.disableBlend();
        }
    }

    private static List<class_1799> findItemsInInventory(class_310 client, CompassRibbonConfig.ItemSlot slot, class_1792 item) {
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        if (slot == CompassRibbonConfig.ItemSlot.NONE) {
            return itemStacks;
        }
        class_1661 inventory = client.field_1724.field_7514;
        class_1799 itemStack = (class_1799)inventory.field_7544.get(0);
        if (itemStack.method_7909() == item) {
            itemStacks.add(itemStack);
        }
        if (slot == CompassRibbonConfig.ItemSlot.HAND) {
            itemStack = inventory.method_7391();
            if (itemStack.method_7909() == item) {
                itemStacks.add(itemStack);
            }
        } else {
            for (int n = 0; n < (slot == CompassRibbonConfig.ItemSlot.HOT_BAR ? class_1661.method_7368() : inventory.field_7547.size()); ++n) {
                itemStack = (class_1799)inventory.field_7547.get(n);
                if (itemStack.method_7909() != item) continue;
                itemStacks.add(itemStack);
            }
        }
        return itemStacks;
    }

    private static boolean inventoryContainsItem(class_310 client, CompassRibbonConfig.ItemSlot slot, class_1792 item) {
        if (slot == CompassRibbonConfig.ItemSlot.NONE) {
            return true;
        }
        class_1661 inventory = client.field_1724.field_7514;
        if (((class_1799)inventory.field_7544.get(0)).method_7909() == item) {
            return true;
        }
        if (slot == CompassRibbonConfig.ItemSlot.HAND) {
            return inventory.method_7391().method_7909() == item;
        }
        for (int n = 0; n < (slot == CompassRibbonConfig.ItemSlot.HOT_BAR ? class_1661.method_7368() : inventory.field_7547.size()); ++n) {
            if (((class_1799)inventory.field_7547.get(n)).method_7909() != item) continue;
            return true;
        }
        return false;
    }

    private static List<RibbonMarker> getMarkersInRange(class_310 client, CompassRibbonConfig config) {
        if (config.mapMarkersOpacity.isTransparent()) {
            return Lists.newArrayList();
        }
        class_746 player = client.field_1724;
        class_5321 playerDimension = player.field_6002.method_27983();
        HashSet<RibbonMarker> ribbonMarkers = new HashSet<RibbonMarker>();
        List<class_1799> maps = CompassRibbonClient.findItemsInInventory(client, ((CompassRibbonConfig.MapSlot)((Object)config.mapMarkersMapSlot.getValue())).getSlot(), class_1802.field_8204);
        for (class_1799 mapStack : maps) {
            int mapId = class_1806.method_8003((class_1799)mapStack);
            MapInfo mapInfo = ClientNetworkHandler.getMapInfo(mapId);
            if (mapInfo == null || !mapInfo.getDimension().equals((Object)playerDimension.method_29177())) continue;
            double maxDistance = mapInfo.getMaxDistance();
            for (MapMarker marker : mapInfo.getMarkers(player.method_19538())) {
                ribbonMarkers.add(new RibbonMapMarker((class_1657)player, marker, maxDistance));
            }
        }
        for (class_1799 compass : CompassRibbonClient.findItemsInInventory(client, ((CompassRibbonConfig.CompassSlot)((Object)config.directionsCompassSlot.getValue())).getSlot(), class_1802.field_8251)) {
            class_2487 tag = compass.method_7969();
            if (tag == null || !tag.method_10573("LodestonePos", 10)) continue;
            class_2338 pos = class_2512.method_10691((class_2487)tag.method_10562("LodestonePos"));
            Optional optional = class_1759.method_26364((class_2487)tag);
            if (!optional.isPresent() || optional.get() != playerDimension) continue;
            ribbonMarkers.add(new RibbonModMarker((class_1657)player, pos, RibbonModMarker.Type.COMPASS, 0.0));
        }
        double minimalDistance = ClientNetworkHandler.recentChange() ? 0.0 : (double)((Integer)config.mapMarkersMinimalDistance.getValue()).intValue();
        double maxYawDifference = (double)((Integer)config.ribbonRange.getValue()).intValue() / 2.0;
        return ribbonMarkers.stream().filter(ribbonMarker -> Math.abs(ribbonMarker.getYaw()) <= maxYawDifference && ribbonMarker.getDistance() >= minimalDistance).sorted(Comparator.comparingDouble(RibbonMarker::getDistance).reversed()).collect(Collectors.toList());
    }

    private static double getRibbonAngle(class_746 player, CompassRibbonConfig config) {
        if (player.field_6002.method_27983() == class_1937.field_25180 && config.directionsInNether.getValue() == CompassRibbonConfig.DirectionsVisibility.RANDOM || player.field_6002.method_27983() == class_1937.field_25181 && config.directionsInEnd.getValue() == CompassRibbonConfig.DirectionsVisibility.RANDOM) {
            class_1800 compass_angle = class_5272.method_27878((class_1792)class_1802.field_8251, (class_2960)new class_2960("angle"));
            return (double)compass_angle.call(class_1799.field_8037, null, (class_1309)player) * 360.0 - 90.0;
        }
        return player.field_6031;
    }

    private static String angleToDirection(float angle) {
        return DIRECTION.get(class_3532.method_15386((float)((angle - 22.5f) / 45.0f)) & 7);
    }

    private static int opacityToAlpha(int opacity) {
        return opacity * 255 / 100 << 24;
    }

    private static float positionToAlpha(float position) {
        return Math.min(1.0f, 3.0f - class_3532.method_15379((float)position) * 6.0f);
    }

    private static float distanceToAlpha(float distance) {
        return (1.0f - Math.min(1.0f, distance / 256.0f)) * 0.5f + 0.5f;
    }

    private static void drawDirection(class_310 client, class_4587 matrixStack, String string, int x, int y, int color, int opacity) {
        if (opacity < 4) {
            return;
        }
        class_327 fontRenderer = client.field_1705.method_1756();
        fontRenderer.method_1729(matrixStack, string, (float)(x - fontRenderer.method_1727(string) / 2), (float)y, color + CompassRibbonClient.opacityToAlpha(opacity));
    }

    private static void drawMarker(class_310 client, int x, int y, int z, RibbonMarker marker, int opacity) {
        if (opacity == 0) {
            return;
        }
        class_289 tessellator = class_289.method_1348();
        client.method_1531().method_22813(marker.getTexture());
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)((float)y + 4.0f), (float)0.02f);
        RenderSystem.scalef((float)4.0f, (float)4.0f, (float)3.0f);
        RenderSystem.translatef((float)-0.125f, (float)0.125f, (float)0.0f);
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(7, class_290.field_1585);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)opacity / 100.0f));
        int texturePos = marker.getTexturePos();
        float tX1 = (float)(texturePos % 16 + 0) / 16.0f;
        float tX2 = (float)(texturePos % 16 + 1) / 16.0f;
        double vX1 = -1.0;
        double vX2 = 1.0;
        float tY1 = (float)(texturePos / 16 + 0) / 16.0f;
        float tY2 = (float)(texturePos / 16 + 1) / 16.0f;
        double vY1 = -1.0;
        double vY2 = 1.0;
        double vZ = 0.001 * (double)z;
        bufferBuilder.method_22912(vX1, vY2, vZ).method_22913(tX1, tY2).method_1344();
        bufferBuilder.method_22912(vX2, vY2, vZ).method_22913(tX2, tY2).method_1344();
        bufferBuilder.method_22912(vX2, vY1, vZ).method_22913(tX2, tY1).method_1344();
        bufferBuilder.method_22912(vX1, vY1, vZ).method_22913(tX1, tY1).method_1344();
        tessellator.method_1350();
        RenderSystem.popMatrix();
    }
}

