/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config;

import chrono.mods.compassribbon.config.value.EnumValue;
import chrono.mods.compassribbon.config.value.IntegerValue;
import chrono.mods.compassribbon.config.value.OpacityValue;

public class CompassRibbonConfig {
    public IntegerValue ribbonWidth = new IntegerValue(90, 30, 100);
    public IntegerValue ribbonRange = new IntegerValue(240, 30, 360);
    public OpacityValue fovHighlightOpacity = new OpacityValue(15);
    public EnumValue<FovHighlightColor> fovHighlightColor = new EnumValue<FovHighlightColor>(FovHighlightColor.BLACK);
    public EnumValue<CompassSlot> directionsCompassSlot = new EnumValue<CompassSlot>(CompassSlot.HAND);
    public EnumValue<DirectionsVisibility> directionsInNether = new EnumValue<DirectionsVisibility>(DirectionsVisibility.HIDDEN);
    public EnumValue<DirectionsVisibility> directionsInEnd = new EnumValue<DirectionsVisibility>(DirectionsVisibility.HIDDEN);
    public OpacityValue directionsOpacity = new OpacityValue(40);
    public EnumValue<DirectionsColor> directionsColor = new EnumValue<DirectionsColor>(DirectionsColor.ORANGE_WHITE);
    public EnumValue<MapSlot> mapMarkersMapSlot = new EnumValue<MapSlot>(MapSlot.HOT_BAR);
    public OpacityValue mapMarkersOpacity = new OpacityValue(80);
    public IntegerValue mapMarkersMinimalDistance = new IntegerValue(2, 0, 32);

    public static enum DirectionsColor {
        WHITE(0xFFFFFF),
        ORANGE_WHITE(0xFFAA00, 0xFFFFFF),
        RED_WHITE(0xFF0000, 0xFFFFFF),
        GREEN(65280);

        private final int color1;
        private final int color2;

        private DirectionsColor(int color1, int color2) {
            this.color1 = color1;
            this.color2 = color2;
        }

        private DirectionsColor(int color) {
            this(color, color);
        }

        public int getColor1() {
            return this.color1;
        }

        public int getColor2() {
            return this.color2;
        }
    }

    public static enum DirectionsVisibility {
        NORMAL,
        RANDOM,
        HIDDEN;

    }

    public static enum FovHighlightColor {
        BLACK(0),
        WHITE(0xFFFFFF);

        private final int color;

        private FovHighlightColor(int color) {
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }
    }

    public static enum MapSlot {
        INVENTORY(ItemSlot.INVENTORY),
        HOT_BAR(ItemSlot.HOT_BAR),
        HAND(ItemSlot.HAND);

        private final ItemSlot slot;

        private MapSlot(ItemSlot slot) {
            this.slot = slot;
        }

        public ItemSlot getSlot() {
            return this.slot;
        }
    }

    public static enum CompassSlot {
        NONE(ItemSlot.NONE),
        INVENTORY(ItemSlot.INVENTORY),
        HOT_BAR(ItemSlot.HOT_BAR),
        HAND(ItemSlot.HAND);

        private final ItemSlot slot;

        private CompassSlot(ItemSlot slot) {
            this.slot = slot;
        }

        public ItemSlot getSlot() {
            return this.slot;
        }
    }

    public static enum ItemSlot {
        NONE,
        INVENTORY,
        HOT_BAR,
        HAND;

    }
}

