/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config;

import chrono.mods.compassribbon.config.value.AbstractValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ConfigManager<T> {
    private final Class<T> configClass;
    private final File file;
    private final Gson gson;
    private final Logger logger;
    private T config;

    public ConfigManager(String mod_id, Class<T> configClass, String loggerName) {
        this.configClass = configClass;
        this.file = FabricLoader.getInstance().getConfigDir().resolve(mod_id + ".json").toFile();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.logger = LogManager.getLogger((String)loggerName);
    }

    public ConfigManager(String mod_id, Class<T> configClass) {
        this(mod_id, configClass, "CrConfig");
    }

    private T getDefaultConfig() {
        try {
            return this.configClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to create ConfigManager", e);
        }
    }

    @Nullable
    private AbstractValue<?> getFieldValue(Field field, T config) {
        if (AbstractValue.class.isAssignableFrom(field.getType())) {
            try {
                return (AbstractValue)field.get(config);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.logger.error("Unable to get configuration field");
            }
        }
        return null;
    }

    private void setFieldValueFromJson(Field field, JsonElement json, T config) {
        if (AbstractValue.class.isAssignableFrom(field.getType())) {
            try {
                ((AbstractValue)field.get(config)).fromJson(json);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.logger.error("Unable to set configuration field '" + field.getName() + "'");
            }
        }
    }

    private String toJson() {
        JsonObject root = new JsonObject();
        for (Field field : this.config.getClass().getDeclaredFields()) {
            AbstractValue<?> value = this.getFieldValue(field, this.config);
            if (value == null || !value.getSaveDefaultValue() && value.isDefaultValue()) continue;
            JsonElement element = value.toJson();
            root.add(field.getName(), element);
        }
        return this.gson.toJson((JsonElement)root);
    }

    private T fromJson(JsonElement json) {
        T config = this.getDefaultConfig();
        if (json != null && json.isJsonObject()) {
            JsonObject root = json.getAsJsonObject();
            for (Field field : config.getClass().getDeclaredFields()) {
                JsonElement element = root.get(field.getName());
                if (element == null) continue;
                this.setFieldValueFromJson(field, element, config);
            }
        }
        return config;
    }

    private void load() {
        JsonElement json = null;
        try {
            json = new JsonParser().parse((Reader)new BufferedReader(new FileReader(this.file)));
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
            this.logger.warn("Couldn't load configuration file");
        }
        this.config = this.fromJson(json);
        if (json == null) {
            this.save();
        }
    }

    public void save() {
        try (FileWriter fileWriter = new FileWriter(this.file);){
            fileWriter.write(this.toJson());
        }
        catch (IOException e) {
            this.logger.error("Couldn't save configuration file");
            e.printStackTrace();
        }
    }

    public T getConfig() {
        if (this.config == null) {
            this.load();
        }
        return this.config;
    }

    public boolean isDefault() {
        return !Stream.of(this.config.getClass().getDeclaredFields()).map(field -> this.getFieldValue((Field)field, this.config)).filter(Objects::nonNull).anyMatch(value -> !value.isDefaultValue());
    }
}

