/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config.gui;

import chrono.mods.compassribbon.config.gui.ConfigListWidget;
import chrono.mods.compassribbon.config.gui.widget.ButtonWidget;
import chrono.mods.compassribbon.config.gui.widget.ResetableWidget;
import chrono.mods.compassribbon.config.util.Translation;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_5499;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConfigScreen
extends class_437 {
    private final class_437 previousScreen;
    private final boolean resetButton;
    private ConfigListWidget list;

    protected AbstractConfigScreen(class_2561 title, class_437 previousScreen, boolean resetButton) {
        super(title);
        this.previousScreen = previousScreen;
        this.resetButton = resetButton;
    }

    protected AbstractConfigScreen(class_2561 title, class_437 previousScreen) {
        this(title, previousScreen, false);
    }

    protected AbstractConfigScreen(String title, class_437 previousScreen, boolean resetButton) {
        this(Translation.translateText(title), previousScreen, resetButton);
    }

    protected AbstractConfigScreen(String title, class_437 previousScreen) {
        this(title, previousScreen, false);
    }

    public void addRow(class_339 ... widgets) {
        this.list.addRow(widgets);
    }

    protected void method_25426() {
        this.list = new ConfigListWidget(this.field_22787, this.field_22789, this.field_22790, 18, this.field_22790 - 32, 24);
        this.field_22786.add(this.list);
        if (this.resetButton) {
            this.method_25411((class_339)ButtonWidget.builder(AbstractConfigScreen.createTranslationKey("reset")).pressAction(() -> this.onReset()).build(this.field_22789 / 2 - 135, this.field_22790 - 27, 130, 20));
            this.method_25411((class_339)ButtonWidget.builder(AbstractConfigScreen.createTranslationKey("done")).pressAction(() -> this.onDone()).build(this.field_22789 / 2 - 135 + 140, this.field_22790 - 27, 130, 20));
        } else {
            this.method_25411((class_339)ButtonWidget.builder(AbstractConfigScreen.createTranslationKey("done")).pressAction(() -> this.onDone()).build(this.field_22789 / 2 - 100, this.field_22790 - 27, 200, 20));
        }
    }

    public void onDone() {
        this.field_22787.method_1507(this.previousScreen);
    }

    public void onReset() {
        for (ConfigListWidget.RowEntry row : this.list.method_25396()) {
            for (class_339 widget : row.method_25396()) {
                if (!(widget instanceof ResetableWidget)) continue;
                ((ResetableWidget)widget).onReset();
            }
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.list.method_25394(matrices, mouseX, mouseY, delta);
        AbstractConfigScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)5, (int)0xFFFFFF);
        super.method_25394(matrices, mouseX, mouseY, delta);
        List<class_5481> toolTip = this.getHoweredWidgetTooltip(mouseX, mouseY);
        if (toolTip != null) {
            this.method_25417(matrices, toolTip, mouseX, mouseY);
        }
    }

    @Nullable
    protected List<class_5481> getHoweredWidgetTooltip(int mouseX, int mouseY) {
        Optional<class_339> optional = this.list.getHoveredWidget(mouseX, mouseY);
        if (optional.isPresent() && optional.get() instanceof class_5499) {
            return ((class_5499)optional.get()).method_31047().orElse(null);
        }
        return null;
    }

    protected static String createTranslationKey(String key) {
        return AbstractConfigScreen.createTranslationKey("cr-config", key);
    }

    protected static String createTranslationKey(String modId, String key) {
        return "text." + modId + ".config." + key;
    }
}

