/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config.gui.widget;

import chrono.mods.compassribbon.config.gui.widget.ResetableWidget;
import chrono.mods.compassribbon.config.gui.widget.WidgetBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_5481;
import net.minecraft.class_5499;

public class NumericWidget
extends class_357
implements class_5499,
ResetableWidget {
    private final double min;
    private final double max;
    private final double step;
    private final Supplier<Double> getter;
    private final Consumer<Double> setter;
    private final Supplier<class_2561> messageProvider;
    private final Optional<List<class_5481>> tooltip;
    private final Runnable resetAction;

    protected NumericWidget(Builder builder, int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)builder.messageProvider.get(), 0.0);
        this.field_22763 = builder.active;
        this.min = builder.min;
        this.max = builder.max;
        this.step = builder.step;
        this.getter = builder.getter;
        this.setter = builder.setter;
        this.messageProvider = builder.messageProvider;
        this.tooltip = builder.tooltip;
        this.field_22753 = this.getRatio(this.getter.get());
        this.resetAction = builder.resetAction;
    }

    static Builder builder(String key, double min, double max, double step, Supplier<Double> getter, Consumer<Double> setter, Supplier<class_2561> messageProvider) {
        return new Builder(key, min, max, step, getter, setter, messageProvider);
    }

    private double adjust(double value) {
        if (this.step > 0.0) {
            value = this.step * (double)Math.round(value / this.step);
        }
        return class_3532.method_15350((double)value, (double)this.min, (double)this.max);
    }

    private double getRatio(double value) {
        return class_3532.method_15350((double)((this.adjust(value) - this.min) / (this.max - this.min)), (double)0.0, (double)1.0);
    }

    public double getValue(double ratio) {
        return this.adjust(class_3532.method_16436((double)class_3532.method_15350((double)ratio, (double)0.0, (double)1.0), (double)this.min, (double)this.max));
    }

    public Optional<List<class_5481>> method_31047() {
        return this.tooltip;
    }

    protected void method_25344() {
        this.setter.accept(this.getValue(this.field_22753));
    }

    protected void method_25346() {
        this.method_25355(this.messageProvider.get());
    }

    @Override
    public void onReset() {
        if (this.resetAction != null) {
            this.resetAction.run();
            this.field_22753 = this.getRatio(this.getter.get());
            this.method_25355(this.messageProvider.get());
        }
    }

    static class Builder
    extends WidgetBuilder<NumericWidget, Builder> {
        private final double min;
        private final double max;
        private final double step;
        private final Supplier<Double> getter;
        private final Consumer<Double> setter;
        private Runnable resetAction;

        protected Builder(String key, double min, double max, double step, Supplier<Double> getter, Consumer<Double> setter, Supplier<class_2561> messageProvider) {
            super(key, messageProvider);
            this.max = max;
            this.min = min;
            this.step = step;
            this.getter = getter;
            this.setter = setter;
        }

        public Builder resetAction(Runnable resetAction) {
            this.resetAction = resetAction;
            return this;
        }

        @Override
        public NumericWidget build(int x, int y, int width, int height) {
            return new NumericWidget(this, x, y, width, height);
        }

        @Override
        Builder getThis() {
            return this;
        }
    }
}

