/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config.value;

import chrono.mods.compassribbon.config.value.AbstractValue;
import com.google.common.base.CaseFormat;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_3532;

public class EnumValue<T extends Enum<T>>
extends AbstractValue<T> {
    private final Map<String, T> nameToConstant = new HashMap<String, T>();
    private final Map<T, String> constantToName = new HashMap<T, String>();
    private final T[] constants;

    public EnumValue(T defaultValue, boolean saveDefaultValue) {
        super(defaultValue, saveDefaultValue);
        for (T constant : this.constants = (Enum[])((Enum)defaultValue).getDeclaringClass().getEnumConstants()) {
            String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, ((Enum)constant).name());
            this.nameToConstant.put(name, constant);
            this.constantToName.put(constant, name);
        }
    }

    public EnumValue(T defaultValue) {
        this(defaultValue, true);
    }

    public void cycle(boolean backward) {
        int amount = backward ? -1 : 1;
        this.setValue(this.constants[class_3532.method_15387((int)(((Enum)this.getValue()).ordinal() + amount), (int)this.constants.length)]);
    }

    public void cycle() {
        this.cycle(false);
    }

    public String getName() {
        return this.constantToName.get(this.getValue());
    }

    @Override
    public JsonElement toJson() {
        return new JsonPrimitive(this.constantToName.get(this.getValue()));
    }

    @Override
    public void fromJson(JsonElement element) {
        Enum constant;
        if (element.isJsonPrimitive() && (constant = (Enum)this.nameToConstant.get(element.getAsString())) != null) {
            this.setValue(constant);
        }
    }
}

