/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config.value;

import chrono.mods.compassribbon.config.value.RangedValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public class IntegerValue
extends RangedValue<Integer> {
    public IntegerValue(int defaultValue, int minValue, int maxValue, int step, boolean saveDefaultValue) {
        super(defaultValue, minValue, maxValue, step, saveDefaultValue);
    }

    public IntegerValue(int defaultValue, int minValue, int maxValue, int step) {
        this(defaultValue, minValue, maxValue, step, true);
    }

    public IntegerValue(int defaultValue, int minValue, int maxValue, boolean saveDefaultValue) {
        this(defaultValue, minValue, maxValue, 1, saveDefaultValue);
    }

    public IntegerValue(int defaultValue, int minValue, int maxValue) {
        this(defaultValue, minValue, maxValue, true);
    }

    @Override
    public JsonElement toJson() {
        return new JsonPrimitive((Number)this.getValue());
    }

    @Override
    public void fromJson(JsonElement element) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            this.setValue(element.getAsInt());
        }
    }

    @Override
    protected Integer adjustValue(Integer value) {
        Integer step = (Integer)this.getStep();
        if (step != 1) {
            return (value + step / 2) / step * step;
        }
        return value;
    }
}

