/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.config.value;

import chrono.mods.compassribbon.config.value.AbstractValue;

public abstract class RangedValue<T extends Comparable<T>>
extends AbstractValue<T> {
    private final T minValue;
    private final T maxValue;
    private final T step;

    public RangedValue(T defaultValue, T minValue, T maxValue, T step, boolean saveDefaultValue) {
        super(defaultValue, saveDefaultValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
    }

    public RangedValue(T defaultValue, T minValue, T maxValue, T step) {
        this(defaultValue, minValue, maxValue, step, true);
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public T getStep() {
        return this.step;
    }

    @Override
    public void setValue(T value) {
        if (value.compareTo(this.minValue) >= 0 && value.compareTo(this.maxValue) <= 0) {
            if ((value = this.adjustValue(value)).compareTo(this.minValue) < 0) {
                value = this.minValue;
            } else if (value.compareTo(this.maxValue) > 0) {
                value = this.maxValue;
            }
            super.setValue(value);
        }
    }

    protected abstract T adjustValue(T var1);
}

