/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.helpers;

import chrono.mods.compassribbon.helpers.MapMarker;
import chrono.mods.compassribbon.mixin.server.MapStateAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_17;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_19;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MapInfo {
    private final int mapId;
    private final class_2960 dimension;
    private final int xCenter;
    private final int zCenter;
    private final byte scale;
    private final boolean showIcons;
    private final boolean unlimitedTracking;
    private final List<MapMarker> markers;
    private static final boolean SORT_MARKERS = true;

    public MapInfo(int mapId, class_2960 dimension, int xCenter, int zCenter, byte scale, boolean showIcons, boolean unlimitedTracking, List<MapMarker> markers) {
        this.mapId = mapId;
        this.dimension = dimension;
        this.xCenter = xCenter;
        this.zCenter = zCenter;
        this.scale = scale;
        this.showIcons = showIcons;
        this.unlimitedTracking = unlimitedTracking;
        this.markers = markers;
    }

    @Nullable
    public static MapInfo fromItemStack(class_1799 itemStack, class_1937 world) {
        class_22 mapState = class_1806.method_7997((class_1799)itemStack, (class_1937)world);
        if (mapState == null) {
            return null;
        }
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        for (class_17 bannerMarker : ((MapStateAccessor)mapState).cr$getBanners().values()) {
            markers.add(new MapMarker(bannerMarker.method_70(), bannerMarker.method_72()));
        }
        for (class_19 frameMarker : ((MapStateAccessor)mapState).cr$getFrames().values()) {
            markers.add(new MapMarker(frameMarker.method_86(), class_20.class_21.field_95));
        }
        class_2487 compoundTag = itemStack.method_7969();
        if (compoundTag != null && compoundTag.method_10573("Decorations", 9)) {
            class_2499 listTag = compoundTag.method_10554("Decorations", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 compoundTag2 = listTag.method_10602(i);
                markers.add(new MapMarker((int)compoundTag2.method_10574("x"), 64, (int)compoundTag2.method_10574("z"), class_20.class_21.method_99((byte)compoundTag2.method_10571("type"))));
            }
        }
        Collections.sort(markers);
        return new MapInfo(class_1806.method_8003((class_1799)itemStack), mapState.field_118.method_29177(), mapState.field_116, mapState.field_115, mapState.field_119, mapState.field_114, mapState.field_113, markers);
    }

    public class_2960 getDimension() {
        return this.dimension;
    }

    public int getMapId() {
        return this.mapId;
    }

    public List<MapMarker> getMarkers(class_243 pos) {
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        if (this.markers.size() > 0 && this.showIcons) {
            double maxDistance = this.getMaxDistance();
            double mapCenterDistance = Math.max(Math.abs(pos.method_10216() - (double)this.xCenter), Math.abs(pos.method_10215() - (double)this.zCenter));
            if (maxDistance == 0.0 || maxDistance >= mapCenterDistance) {
                for (MapMarker marker : this.markers) {
                    markers.add(marker);
                }
            }
        }
        return markers;
    }

    public double getMaxDistance() {
        return this.unlimitedTracking ? 0.0 : (double)(320 << this.scale);
    }

    public static MapInfo fromTag(class_2487 compoundTag) {
        ArrayList<MapMarker> markers = new ArrayList<MapMarker>();
        class_2499 listTag = compoundTag.method_10554("markers", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            markers.add(MapMarker.fromTag(listTag.method_10602(i)));
        }
        return new MapInfo(compoundTag.method_10550("mapId"), new class_2960(compoundTag.method_10558("dimension")), compoundTag.method_10550("xCenter"), compoundTag.method_10550("zCenter"), compoundTag.method_10571("scale"), compoundTag.method_10577("trackingPosition"), compoundTag.method_10577("unlimitedTracking"), markers);
    }

    public class_2487 toTag(class_2487 compoundTag) {
        compoundTag.method_10569("mapId", this.mapId);
        compoundTag.method_10582("dimension", this.dimension.toString());
        compoundTag.method_10569("xCenter", this.xCenter);
        compoundTag.method_10569("zCenter", this.zCenter);
        compoundTag.method_10567("scale", this.scale);
        compoundTag.method_10556("trackingPosition", this.showIcons);
        compoundTag.method_10556("unlimitedTracking", this.unlimitedTracking);
        class_2499 listTag = new class_2499();
        for (MapMarker marker : this.markers) {
            listTag.add((Object)marker.toTag());
        }
        compoundTag.method_10566("markers", (class_2520)listTag);
        return compoundTag;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MapInfo other = (MapInfo)object;
        return this.mapId == other.mapId && this.dimension == other.dimension && this.xCenter == other.xCenter && this.zCenter == other.zCenter && this.scale == other.scale && this.showIcons == other.showIcons && this.unlimitedTracking == other.unlimitedTracking && this.markers.equals(other.markers);
    }

    public int hashCode() {
        return Objects.hash(this.mapId, this.dimension, this.xCenter, this.zCenter, this.scale, this.showIcons, this.unlimitedTracking, this.markers);
    }

    public String toString() {
        return "mapId: " + this.mapId + ", center: " + this.xCenter + "/" + this.zCenter + ", scale: 1/" + (1 << this.scale) + ", " + this.markers.size() + " marker(s): " + this.markers;
    }
}

