/*
 * Decompiled with CFR 0.152.
 */
package chrono.mods.compassribbon.helpers;

import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public abstract class RibbonMarker {
    private static final double RAD_TO_DEG = 57.29577951308232;
    private final int x;
    private final int y;
    private final int z;
    private final double distance;
    private final double pitch;
    private final double yaw;
    private final double maxDistance;

    public RibbonMarker(class_1657 player, double x, double y, double z, double maxDistance) {
        double rx = x - player.method_23317();
        double ry = y - player.method_23318();
        double rz = z - player.method_23321();
        this.x = (int)x;
        this.y = (int)y;
        this.z = (int)z;
        this.distance = class_3532.method_15368((double)(rx * rx + rz * rz));
        this.pitch = -class_3532.method_15349((double)ry, (double)Math.max(this.distance, 8.0)) * 57.29577951308232;
        this.yaw = class_3532.method_15338((double)(-(class_3532.method_15349((double)rx, (double)rz) * 57.29577951308232 + (double)player.field_6031)));
        this.maxDistance = maxDistance;
    }

    public RibbonMarker(class_1657 player, int x, int y, int z, double maxDistance) {
        this(player, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, maxDistance);
    }

    public RibbonMarker(class_1657 player, class_2338 pos, double maxDistance) {
        this(player, pos.method_10263(), pos.method_10264(), pos.method_10260(), maxDistance);
    }

    public RibbonMarker(class_1657 player, class_243 pos, double maxDistance) {
        this(player, pos.method_10216(), pos.method_10214(), pos.method_10215(), maxDistance);
    }

    public double getDistance() {
        return this.distance;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        RibbonMarker other = (RibbonMarker)object;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.getTexturePos() == other.getTexturePos();
    }

    public int hashCode() {
        return ((this.y + this.z * 31) * 31 + this.x) * 31 + this.getTexturePos();
    }

    public String toString() {
        return "RibbonMarker: " + this.distance + "/" + this.maxDistance + ", " + this.pitch + ", " + this.yaw;
    }

    public abstract class_2960 getTexture();

    public abstract int getTexturePos();
}

