/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_6880;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiCheckBox
extends GuiLabel {
    @Environment(value=EnvType.CLIENT)
    private static StyleDisplay PARTIAL_STYLE;
    public static final int CHECKBOX_WIDTH = 7;
    public boolean value = false;
    public String title;
    public boolean partial = false;
    public Consumer<Boolean> changed;

    public GuiCheckBox(String name, boolean value) {
        super(name);
        this.value = value;
    }

    public GuiCheckBox consumeChanged(Consumer<Boolean> changed) {
        this.changed = changed;
        return this;
    }

    @Override
    public GuiCheckBox setTranslate(String translate) {
        return (GuiCheckBox)super.setTranslate(translate);
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return super.preferredWidth(availableWidth) + 7 + 3;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return Math.max(10, super.preferredHeight(width, availableHeight));
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT_NO_DISABLE;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void renderContent(class_4587 matrix, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        int yoffset = 0;
        GuiStyle style = this.getStyle();
        if (!this.enabled) {
            style.disabled.render(matrix, 0.0, yoffset, 7.0, 7.0);
        }
        style.get(ControlFormatting.ControlStyleBorder.SMALL).render(matrix, 0.0, yoffset, 7.0, 7.0);
        style.get(ControlFormatting.ControlStyleFace.NESTED_BACKGROUND, rect.inside(mouseX, mouseY)).render(matrix, 1.0, yoffset + 1, 5.0, 5.0);
        if (this.value) {
            class_310.method_1551().field_1772.method_1729(matrix, "x", 1.0f, (float)(yoffset - 1), this.enabled ? -1 : style.fontColorHighlight.toInt());
        } else if (this.partial) {
            if (PARTIAL_STYLE == null) {
                PARTIAL_STYLE = new DisplayColor();
            }
            PARTIAL_STYLE.render(matrix, 2.0, yoffset + 2, 3.0, 3.0);
        }
        matrix.method_22903();
        matrix.method_46416(10.0f, 0.0f, 0.0f);
        this.text.render(matrix);
        matrix.method_22909();
    }

    public void set(boolean value) {
        if (this.value == value) {
            return;
        }
        this.value = value;
        this.raiseEvent(new GuiControlChangedEvent(this));
        if (this.changed != null) {
            this.changed.accept(value);
        }
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        GuiCheckBox.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
        this.set(!this.value);
        return true;
    }
}

