/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.integration;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.event.GuiTooltipEvent;
import team.creative.creativecore.common.gui.integration.ScreenEventListener;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.geo.Rect;

public interface IGuiIntegratedParent
extends IGuiParent {
    public static final GuiLayer EMPTY = new GuiLayer("empty"){

        @Override
        public void create() {
        }
    };

    public List<GuiLayer> getLayers();

    public GuiLayer getTopLayer();

    default public boolean isOpen(Class<? extends GuiLayer> clazz) {
        for (GuiLayer layer : this.getLayers()) {
            if (!clazz.isInstance(layer)) continue;
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    default public void render(class_4587 matrixStack, class_437 screen, ScreenEventListener listener, int mouseX, int mouseY) {
        int width = screen.field_22789;
        int height = screen.field_22790;
        listener.tick();
        Rect screenRect = Rect.getScreenRect();
        List<GuiLayer> layers = this.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            GuiLayer layer = layers.get(i);
            if (i == layers.size() - 1 && layer.hasGrayBackground()) {
                RenderSystem.disableDepthTest();
                GuiRenderHelper.verticalGradientRect(matrixStack, 0, 0, width, height, -1072689136, -804253680);
            }
            matrixStack.method_22903();
            int offX = (width - layer.getWidth()) / 2;
            int offY = (height - layer.getHeight()) / 2;
            matrixStack.method_46416((float)offX, (float)offY, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Rect controlRect = new Rect(offX, offY, offX + layer.getWidth(), offY + layer.getHeight());
            layer.render(matrixStack, null, controlRect, screenRect.intersection(controlRect), 1.0, mouseX, mouseY);
            matrixStack.method_22909();
            RenderSystem.disableScissor();
        }
        if (layers.isEmpty()) {
            return;
        }
        GuiLayer layer = this.getTopLayer();
        GuiTooltipEvent event = layer.getTooltipEvent(null, mouseX - listener.getOffsetX(), mouseY - listener.getOffsetY());
        if (event != null) {
            layer.raiseEvent(event);
            if (!event.isCanceled()) {
                screen.method_32634(matrixStack, event.tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    @Override
    default public void raiseEvent(GuiEvent event) {
    }

    @Override
    default public void reflow() {
    }

    public void openLayer(GuiLayer var1);

    public void closeLayer(int var1);

    @Override
    default public boolean isParent(IGuiParent parent) {
        return parent == this;
    }

    @Override
    default public boolean hasGui() {
        return true;
    }

    default public GuiControl get(String control) {
        for (GuiLayer layer : this.getLayers()) {
            if (!control.startsWith(layer.getNestedName())) continue;
            if (control.equals(layer.getNestedName())) {
                return layer;
            }
            return layer.get(control.substring(layer.getNestedName().length() + 1));
        }
        return null;
    }

    @Override
    default public Rect toScreenRect(GuiControl control, Rect rect) {
        if (control instanceof GuiLayer) {
            GuiLayer layer = (GuiLayer)control;
            int offX = (class_310.method_1551().method_22683().method_4486() - layer.getWidth()) / 2;
            int offY = (class_310.method_1551().method_22683().method_4502() - layer.getHeight()) / 2;
            rect.move(offX, offY);
        }
        return rect;
    }

    @Override
    default public Rect toLayerRect(GuiControl control, Rect rect) {
        return rect;
    }

    @Override
    default public IGuiIntegratedParent getIntegratedParent() {
        return this;
    }

    public void send(CreativePacket var1);
}

