/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2335;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_263;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.unsafe.CreativeHackery;

public class AABBVoxelShape
extends class_263 {
    public class_238 bb;

    public static AABBVoxelShape create(class_238 bb) {
        AABBVoxelShape shape = CreativeHackery.allocateInstance(AABBVoxelShape.class);
        shape.bb = bb;
        return shape;
    }

    protected AABBVoxelShape() {
        super(null, null, 0);
    }

    public boolean contains(Vec3d vec) {
        if (vec.x > this.bb.field_1323 && vec.x < this.bb.field_1320) {
            if (vec.y > this.bb.field_1322 && vec.y < this.bb.field_1325) {
                return vec.z > this.bb.field_1321 && vec.z < this.bb.field_1324;
            }
            return false;
        }
        return false;
    }

    protected double get(Facing facing) {
        switch (facing) {
            case EAST: {
                return this.bb.field_1320;
            }
            case WEST: {
                return this.bb.field_1323;
            }
            case UP: {
                return this.bb.field_1325;
            }
            case DOWN: {
                return this.bb.field_1322;
            }
            case SOUTH: {
                return this.bb.field_1324;
            }
            case NORTH: {
                return this.bb.field_1321;
            }
        }
        return 0.0;
    }

    public Vec3d getCorner(BoxCorner corner) {
        return new Vec3d(this.getCornerX(corner), this.getCornerY(corner), this.getCornerZ(corner));
    }

    public double getCornerValue(BoxCorner corner, Axis axis) {
        return this.get(corner.getFacing(axis));
    }

    public double getCornerX(BoxCorner corner) {
        return this.get(corner.x);
    }

    public double getCornerY(BoxCorner corner) {
        return this.get(corner.y);
    }

    public double getCornerZ(BoxCorner corner) {
        return this.get(corner.z);
    }

    public Vec3d getSizeVec() {
        return new Vec3d(this.bb.field_1320 - this.bb.field_1323, this.bb.field_1325 - this.bb.field_1322, this.bb.field_1324 - this.bb.field_1321);
    }

    public double getVolume() {
        return (this.bb.field_1320 - this.bb.field_1323) * (this.bb.field_1325 - this.bb.field_1322) * (this.bb.field_1324 - this.bb.field_1321);
    }

    public double getIntersectionVolume(class_238 other) {
        double d0 = Math.max(this.bb.field_1323, other.field_1323);
        double d1 = Math.max(this.bb.field_1322, other.field_1322);
        double d2 = Math.max(this.bb.field_1321, other.field_1321);
        double d3 = Math.min(this.bb.field_1320, other.field_1320);
        double d4 = Math.min(this.bb.field_1325, other.field_1325);
        double d5 = Math.min(this.bb.field_1324, other.field_1324);
        if (d0 < d3 && d1 < d4 && d2 < d5) {
            return Math.abs((d3 - d0) * (d4 - d1) * (d5 - d2));
        }
        return 0.0;
    }

    public double getSize(class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return this.bb.field_1320 - this.bb.field_1323;
            }
            case field_11052: {
                return this.bb.field_1325 - this.bb.field_1322;
            }
            case field_11051: {
                return this.bb.field_1324 - this.bb.field_1321;
            }
        }
        return 0.0;
    }

    public double getMin(class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return this.bb.field_1323;
            }
            case field_11052: {
                return this.bb.field_1322;
            }
            case field_11051: {
                return this.bb.field_1321;
            }
        }
        return 0.0;
    }

    public double getMax(class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return this.bb.field_1320;
            }
            case field_11052: {
                return this.bb.field_1325;
            }
            case field_11051: {
                return this.bb.field_1324;
            }
        }
        return 0.0;
    }

    public double getMin(Axis axis) {
        switch (axis) {
            case X: {
                return this.bb.field_1323;
            }
            case Y: {
                return this.bb.field_1322;
            }
            case Z: {
                return this.bb.field_1321;
            }
        }
        return 0.0;
    }

    public double getMax(Axis axis) {
        switch (axis) {
            case X: {
                return this.bb.field_1320;
            }
            case Y: {
                return this.bb.field_1325;
            }
            case Z: {
                return this.bb.field_1324;
            }
        }
        return 0.0;
    }

    public static double get(class_238 bb, Facing facing) {
        switch (facing) {
            case EAST: {
                return bb.field_1320;
            }
            case WEST: {
                return bb.field_1323;
            }
            case UP: {
                return bb.field_1325;
            }
            case DOWN: {
                return bb.field_1322;
            }
            case SOUTH: {
                return bb.field_1324;
            }
            case NORTH: {
                return bb.field_1321;
            }
        }
        return 0.0;
    }

    public static double getMin(class_238 bb, Axis axis) {
        switch (axis) {
            case X: {
                return bb.field_1323;
            }
            case Y: {
                return bb.field_1322;
            }
            case Z: {
                return bb.field_1321;
            }
        }
        return 0.0;
    }

    public static double getMax(class_238 bb, Axis axis) {
        switch (axis) {
            case X: {
                return bb.field_1320;
            }
            case Y: {
                return bb.field_1325;
            }
            case Z: {
                return bb.field_1324;
            }
        }
        return 0.0;
    }

    public static double getMin(class_238 bb, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return bb.field_1323;
            }
            case field_11052: {
                return bb.field_1322;
            }
            case field_11051: {
                return bb.field_1321;
            }
        }
        return 0.0;
    }

    public static double getMax(class_238 bb, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return bb.field_1320;
            }
            case field_11052: {
                return bb.field_1325;
            }
            case field_11051: {
                return bb.field_1324;
            }
        }
        return 0.0;
    }

    public static Vec3d getCorner(class_238 bb, BoxCorner corner) {
        return new Vec3d(AABBVoxelShape.getCornerX(bb, corner), AABBVoxelShape.getCornerY(bb, corner), AABBVoxelShape.getCornerZ(bb, corner));
    }

    public static double getCornerValue(class_238 bb, BoxCorner corner, Axis axis) {
        return AABBVoxelShape.get(bb, corner.getFacing(axis));
    }

    public static double getCornerX(class_238 bb, BoxCorner corner) {
        return AABBVoxelShape.get(bb, corner.x);
    }

    public static double getCornerY(class_238 bb, BoxCorner corner) {
        return AABBVoxelShape.get(bb, corner.y);
    }

    public static double getCornerZ(class_238 bb, BoxCorner corner) {
        return AABBVoxelShape.get(bb, corner.z);
    }

    protected DoubleList method_1109(class_2350.class_2351 axis) {
        throw new UnsupportedOperationException();
    }

    public double method_1091(class_2350.class_2351 axis) {
        return this.bb.method_1001(axis);
    }

    public double method_1105(class_2350.class_2351 axis) {
        return this.bb.method_990(axis);
    }

    public class_238 method_1107() {
        return this.bb;
    }

    protected double method_1099(class_2350.class_2351 axis, int p_83258_) {
        return this.method_1109(axis).getDouble(p_83258_);
    }

    public boolean method_1110() {
        return false;
    }

    public class_265 method_1096(double x, double y, double z) {
        return AABBVoxelShape.create(this.bb.method_989(x, y, z));
    }

    public class_265 method_1097() {
        return this;
    }

    public void method_1104(class_259.class_260 consumer) {
        throw new UnsupportedOperationException();
    }

    public void method_1089(class_259.class_260 consumer) {
        consumer.consume(this.bb.field_1323, this.bb.field_1322, this.bb.field_1321, this.bb.field_1320, this.bb.field_1325, this.bb.field_1324);
    }

    public List<class_238> method_1090() {
        return new SingletonList<class_238>(this.bb);
    }

    public double method_35593(class_2350.class_2351 axis, double one, double two) {
        return this.method_1091(axis);
    }

    public double method_1102(class_2350.class_2351 axis, double one, double two) {
        return this.method_1105(axis);
    }

    protected int method_1100(class_2350.class_2351 axis, double value) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public class_3965 method_1092(class_243 pos, class_243 look, class_2338 block) {
        return class_238.method_1010(new SingletonList<class_238>(this.bb), (class_243)pos, (class_243)look, (class_2338)block);
    }

    public Optional<class_243> method_33661(class_243 vec) {
        class_243 avec3 = null;
        double d0 = class_3532.method_15350((double)vec.method_10216(), (double)this.bb.field_1323, (double)this.bb.field_1320);
        double d1 = class_3532.method_15350((double)vec.method_10214(), (double)this.bb.field_1322, (double)this.bb.field_1325);
        double d2 = class_3532.method_15350((double)vec.method_10215(), (double)this.bb.field_1321, (double)this.bb.field_1324);
        if (avec3 == null || vec.method_1028(d0, d1, d2) < vec.method_1025(avec3)) {
            avec3 = new class_243(d0, d1, d2);
        }
        return Optional.of(avec3);
    }

    public class_265 method_20538(class_2350 p_83264_) {
        return this;
    }

    public double collideStepUp(class_238 other, class_238 otherY, double offset) {
        double newOffset = this.method_1108(class_2350.class_2351.field_11052, otherY, offset);
        if (offset > 0.0 ? newOffset < offset : newOffset > offset) {
            return newOffset / 2.0;
        }
        return newOffset;
    }

    public double method_1108(class_2350.class_2351 axis, class_238 bb, double value) {
        throw new UnsupportedOperationException();
    }

    protected double method_1103(class_2335 cycle, class_238 bb, double distance) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "AABBVoxelShape[" + this.bb + "]";
    }
}

