/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativeNetworkField;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetworkPacket<T extends CreativePacket> {
    public final Class<T> classType;
    public final Supplier<T> supplier;
    public List<CreativeNetworkField> parsers = new ArrayList<CreativeNetworkField>();

    public CreativeNetworkPacket(Class<T> classType, Supplier<T> supplier) {
        this.classType = classType;
        this.supplier = supplier;
        for (Field field : this.classType.getFields()) {
            if (Modifier.isTransient(field.getModifiers()) || field.isAnnotationPresent(OnlyIn.class) || field.isAnnotationPresent(Environment.class)) continue;
            CreativeNetworkField parser = CreativeNetworkField.create(field);
            if (parser != null) {
                this.parsers.add(parser);
                continue;
            }
            throw new RuntimeException("Could not find parser for " + classType.getName() + "." + field.getName() + "! type: " + field.getType().getName());
        }
    }

    public void write(T packet, class_2540 buffer) {
        for (CreativeNetworkField parser : this.parsers) {
            parser.write((CreativePacket)packet, buffer);
        }
    }

    public T read(class_2540 buffer) {
        CreativePacket message = (CreativePacket)this.supplier.get();
        for (CreativeNetworkField parser : this.parsers) {
            parser.read(message, buffer);
        }
        return (T)message;
    }
}

