/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_315;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;
import team.creative.creativecore.common.util.math.geo.Rect;

public abstract class GuiLayer
extends GuiParent {
    @Environment(value=EnvType.CLIENT)
    public GuiStyle style;
    public final Rect rect;
    private final GuiSyncHolder.GuiSyncHolderLayer sync = new GuiSyncHolder.GuiSyncHolderLayer(this);

    public GuiLayer(String name) {
        super(name, GuiFlow.STACK_X);
        this.rect = new Rect(0.0, 0.0, 0.0, 0.0);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.style = GuiStyle.getStyle(name);
        }
    }

    public GuiLayer(String name, int width, int height) {
        super(name, (GuiFlow)GuiFlow.STACK_X, width, height);
        this.rect = new Rect(0.0, 0.0, width, height);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.style = GuiStyle.getStyle(name);
        }
    }

    public GuiSyncHolder.GuiSyncHolderLayer getSyncHolder() {
        return this.sync;
    }

    public int getWidth() {
        return (int)this.rect.getWidth();
    }

    public int getHeight() {
        return (int)this.rect.getHeight();
    }

    @Override
    public void init() {
        this.createSync(this.sync);
        this.create();
        super.init();
        this.reflow();
    }

    public void reinit() {
        super.init();
        this.reflow();
    }

    @Override
    public void reflow() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        if (!this.hasPreferredDimensions) {
            this.rect.maxX = this.preferredWidth() + this.getContentOffset() * 2;
            this.rect.maxY = this.preferredHeight() + this.getContentOffset() * 2;
        }
        this.flowX((int)this.rect.getWidth() - this.getContentOffset() * 2, this.preferredWidth());
        this.flowY((int)this.rect.getHeight() - this.getContentOffset() * 2, this.preferredHeight());
    }

    public abstract void create();

    public void createSync(GuiSyncHolder holder) {
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.GUI;
    }

    @Override
    public String getNestedName() {
        return "gui." + super.getNestedName();
    }

    @Override
    public GuiLayer getLayer() {
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public GuiStyle getStyle() {
        return this.style;
    }

    public boolean closeLayerUsingEscape() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public class_315 getSettings() {
        return class_310.method_1551().field_1690;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean hasGrayBackground() {
        return true;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.closeLayerUsingEscape()) {
                this.closeTopLayer();
            }
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.getSettings().field_1822.method_1417(keyCode, scanCode)) {
            this.closeTopLayer();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLayer() {
        return true;
    }
}

