/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3417;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.controls.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.controls.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlot;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.type.map.HashMapList;

public class GuiStackSelectorExtension
extends GuiScrollY {
    public GuiStackSelector comboBox;
    public String search = "";
    protected int cachedWidth;

    public GuiStackSelectorExtension(String name, class_1657 player, GuiStackSelector comboBox) {
        super(name);
        this.comboBox = comboBox;
        this.registerEventChanged(event -> {
            if (event.control.is("searchBar")) {
                this.search = ((GuiTextfield)event.control).getText();
                this.reloadControls();
            }
        });
        this.registerEventClick(event -> {
            if (event.control instanceof GuiSlot && event.control.isParent(this)) {
                comboBox.setSelected(((GuiSlot)event.control).getStack());
                GuiStackSelectorExtension.playSound(class_3417.field_15015);
                comboBox.closeBox();
            }
        });
        this.align = Align.STRETCH;
        this.reloadControls();
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (super.mouseClicked(rect, x, y, button)) {
            this.comboBox.extensionLostFocus = false;
        }
        return true;
    }

    @Override
    public int preferredWidth() {
        return 100;
    }

    @Override
    public int preferredHeight() {
        return 100;
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedWidth = width;
        super.flowX(width, preferred);
    }

    public void reflowInternal() {
        this.flowX(this.cachedWidth, this.getPreferredWidth());
        this.flowY(this.cachedHeight, this.getPreferredHeight());
    }

    public void reloadControls() {
        HashMapList<String, class_1799> stacks;
        if (this.comboBox == null) {
            return;
        }
        HashMapList<String, class_1799> hashMapList = stacks = this.search == null || this.search.equals("") ? this.comboBox.getStacks() : new HashMapList<String, class_1799>();
        if (this.search != null && !this.search.equals("")) {
            for (Map.Entry<String, ArrayList<class_1799>> entry : this.comboBox.getStacks().entrySet()) {
                for (class_1799 stack : entry.getValue()) {
                    if (!GuiStackSelector.contains(this.search, stack)) continue;
                    stacks.add(entry.getKey(), stack);
                }
            }
        }
        GuiTextfield textfield = (GuiTextfield)this.get("searchBar");
        this.clear();
        if (this.comboBox.searchBar) {
            if (textfield == null) {
                textfield = new GuiTextfield("searchBar", this.search == null ? "" : this.search);
            }
            this.add(textfield);
            textfield.focus();
        }
        for (Map.Entry entry : stacks.entrySet()) {
            this.add(new GuiLabel("title").setTitle((class_2561)new class_2588((String)entry.getKey())));
            class_1277 container = new class_1277(entry.getValue().size());
            int i = 0;
            for (class_1799 stack : entry.getValue()) {
                container.method_5447(i, stack);
                ++i;
            }
            this.add(new GuiInventoryGrid((String)entry.getKey(), (class_1263)container));
        }
        if (this.hasGui()) {
            this.reflowInternal();
        }
    }

    @Override
    public void looseFocus() {
        this.comboBox.extensionLostFocus = true;
    }
}

