/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.level;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2823;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_6603;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import team.creative.creativecore.common.level.CreativeLevel;

public class FakeChunkCache
extends class_2802 {
    private static final Logger LOGGER = LogManager.getLogger();
    public final CreativeLevel level;
    private final class_2818 emptyChunk;
    private final class_3568 lightEngine;
    private volatile Storage storage;

    public FakeChunkCache(CreativeLevel level, int radius) {
        this.level = level;
        this.emptyChunk = new class_2812((class_1937)level, new class_1923(0, 0), null);
        this.lightEngine = new class_3568((class_2823)this, true, level.method_8597().method_12491());
        this.storage = new Storage(FakeChunkCache.calculateStorageRange(radius));
    }

    private static boolean isValidChunk(@Nullable class_2818 p_104439_, int p_104440_, int p_104441_) {
        if (p_104439_ == null) {
            return false;
        }
        class_1923 chunkpos = p_104439_.method_12004();
        return chunkpos.field_9181 == p_104440_ && chunkpos.field_9180 == p_104441_;
    }

    private static int calculateStorageRange(int p_104449_) {
        return Math.max(2, p_104449_) + 3;
    }

    public class_3568 method_12130() {
        return this.lightEngine;
    }

    @Nullable
    public class_2818 getChunk(int i, int j, @NotNull class_2806 chunkStatus, boolean bl) {
        class_2818 levelchunk;
        if (this.storage.inRange(i, j) && FakeChunkCache.isValidChunk(levelchunk = this.storage.getChunk(this.storage.getIndex(i, j)), i, j)) {
            return levelchunk;
        }
        return bl ? this.emptyChunk : null;
    }

    public class_1922 method_16399() {
        return this.level;
    }

    @Nullable
    public class_2818 replaceWithPacketData(int p_194117_, int p_194118_, class_2540 p_194119_, class_2487 p_194120_, Consumer<class_6603.class_6605> p_194121_) {
        if (!this.storage.inRange(p_194117_, p_194118_)) {
            LOGGER.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)p_194117_, (Object)p_194118_);
            return null;
        }
        int i = this.storage.getIndex(p_194117_, p_194118_);
        class_2818 levelchunk = this.storage.chunks.get(i);
        class_1923 chunkpos = new class_1923(p_194117_, p_194118_);
        if (!FakeChunkCache.isValidChunk(levelchunk, p_194117_, p_194118_)) {
            levelchunk = new class_2818((class_1937)this.level, chunkpos);
            levelchunk.method_12224(p_194119_, p_194120_, p_194121_);
            this.storage.replace(i, levelchunk);
        } else {
            levelchunk.method_12224(p_194119_, p_194120_, p_194121_);
        }
        this.level.onChunkLoaded(chunkpos);
        return levelchunk;
    }

    public void method_12127(BooleanSupplier booleanSupplier, boolean bl) {
    }

    public void updateViewCenter(int p_104460_, int p_104461_) {
        this.storage.viewCenterX = p_104460_;
        this.storage.viewCenterZ = p_104461_;
    }

    public void updateViewRadius(int p_104417_) {
        int i = this.storage.chunkRadius;
        int j = FakeChunkCache.calculateStorageRange(p_104417_);
        if (i != j) {
            Storage clientchunkcache$storage = new Storage(j);
            clientchunkcache$storage.viewCenterX = this.storage.viewCenterX;
            clientchunkcache$storage.viewCenterZ = this.storage.viewCenterZ;
            for (int k = 0; k < this.storage.chunks.length(); ++k) {
                class_2818 levelchunk = this.storage.chunks.get(k);
                if (levelchunk == null) continue;
                class_1923 chunkpos = levelchunk.method_12004();
                if (!clientchunkcache$storage.inRange(chunkpos.field_9181, chunkpos.field_9180)) continue;
                clientchunkcache$storage.replace(clientchunkcache$storage.getIndex(chunkpos.field_9181, chunkpos.field_9180), levelchunk);
            }
            this.storage = clientchunkcache$storage;
        }
    }

    public String method_12122() {
        return this.storage.chunks.length() + ", " + this.method_14151();
    }

    public int method_14151() {
        return this.storage.chunkCount;
    }

    public void method_12247(class_1944 p_104436_, class_4076 p_104437_) {
        class_310.method_1551().field_1769.method_8571(p_104437_.method_18674(), p_104437_.method_18683(), p_104437_.method_18687());
    }

    public void addEntity(class_1297 p_143371_) {
    }

    public void removeEntity(class_1297 p_143375_) {
    }

    @Environment(value=EnvType.CLIENT)
    final class Storage {
        private final AtomicReferenceArray<class_2818> chunks;
        private final int chunkRadius;
        private final int viewRange;
        private volatile int viewCenterX;
        private volatile int viewCenterZ;
        private int chunkCount;

        Storage(int p_104474_) {
            this.chunkRadius = p_104474_;
            this.viewRange = p_104474_ * 2 + 1;
            this.chunks = new AtomicReferenceArray(this.viewRange * this.viewRange);
        }

        int getIndex(int p_104482_, int p_104483_) {
            return Math.floorMod(p_104483_, this.viewRange) * this.viewRange + Math.floorMod(p_104482_, this.viewRange);
        }

        protected void replace(int p_104485_, @Nullable class_2818 p_104486_) {
            class_2818 levelchunk = this.chunks.getAndSet(p_104485_, p_104486_);
            if (levelchunk != null) {
                --this.chunkCount;
                FakeChunkCache.this.level.unload(levelchunk);
            }
            if (p_104486_ != null) {
                ++this.chunkCount;
            }
        }

        protected class_2818 replace(int p_104488_, class_2818 p_104489_, @Nullable class_2818 p_104490_) {
            if (this.chunks.compareAndSet(p_104488_, p_104489_, p_104490_) && p_104490_ == null) {
                --this.chunkCount;
            }
            FakeChunkCache.this.level.unload(p_104489_);
            return p_104489_;
        }

        boolean inRange(int p_104501_, int p_104502_) {
            return Math.abs(p_104501_ - this.viewCenterX) <= this.chunkRadius && Math.abs(p_104502_ - this.viewCenterZ) <= this.chunkRadius;
        }

        @Nullable
        protected class_2818 getChunk(int p_104480_) {
            return this.chunks.get(p_104480_);
        }
    }
}

