/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiCheckBox
extends GuiLabel {
    @Environment(value=EnvType.CLIENT)
    private static StyleDisplay partialStyle;
    public static final int checkBoxWidth = 7;
    public boolean value = false;
    public String title;
    public boolean partial = false;

    public GuiCheckBox(String name, String title, boolean value) {
        super(name);
        this.value = value;
        this.title = title;
    }

    public GuiCheckBox(String title, boolean value) {
        this(title, title, value);
    }

    @Override
    public GuiCheckBox setTranslate(String translate) {
        return (GuiCheckBox)super.setTranslate(translate);
    }

    @Override
    public int getPreferredWidth() {
        return super.getPreferredWidth() + 7 + 3;
    }

    @Override
    public int getPreferredHeight(int width) {
        return Math.max(10, super.getPreferredHeight(width));
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT_NO_DISABLE;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void renderContent(class_4587 matrix, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        int yoffset = 0;
        GuiStyle style = this.getStyle();
        if (!this.enabled) {
            style.disabled.render(matrix, 0.0, yoffset, 7.0, 7.0);
        }
        style.get(ControlFormatting.ControlStyleBorder.SMALL).render(matrix, 0.0, yoffset, 7.0, 7.0);
        style.get(ControlFormatting.ControlStyleFace.NESTED_BACKGROUND, rect.inside(mouseX, mouseY)).render(matrix, 1.0, yoffset + 1, 5.0, 5.0);
        if (this.value) {
            class_310.method_1551().field_1772.method_1729(matrix, "x", 1.0f, (float)(yoffset - 1), this.enabled ? -1 : style.fontColorHighlight.toInt());
        } else if (this.partial) {
            if (partialStyle == null) {
                partialStyle = new DisplayColor();
            }
            partialStyle.render(matrix, 2.0, yoffset + 2, 3.0, 3.0);
        }
        matrix.method_22903();
        matrix.method_22904(10.0, 0.0, 0.0);
        this.text.render(matrix);
        matrix.method_22909();
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        GuiCheckBox.playSound(class_3417.field_15015);
        this.value = !this.value;
        this.raiseEvent(new GuiControlChangedEvent(this));
        return true;
    }
}

