/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.base;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Axis {
    X{

        @Override
        public double get(double x, double y, double z) {
            return x;
        }

        @Override
        public float get(float x, float y, float z) {
            return x;
        }

        @Override
        public int get(int x, int y, int z) {
            return x;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return x;
        }

        @Override
        public Axis one() {
            return Y;
        }

        @Override
        public Axis two() {
            return Z;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.EAST : Facing.WEST;
        }

        @Override
        public class_2350.class_2351 toVanilla() {
            return class_2350.class_2351.field_11048;
        }

        @Override
        public class_2382 mirror(class_2382 vec) {
            return new class_2382(-vec.method_10263(), vec.method_10264(), vec.method_10260());
        }

        @Override
        public class_2338 mirror(class_2338 vec) {
            return new class_2338(-vec.method_10263(), vec.method_10264(), vec.method_10260());
        }
    }
    ,
    Y{

        @Override
        public double get(double x, double y, double z) {
            return y;
        }

        @Override
        public float get(float x, float y, float z) {
            return y;
        }

        @Override
        public int get(int x, int y, int z) {
            return y;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return y;
        }

        @Override
        public Axis one() {
            return Z;
        }

        @Override
        public Axis two() {
            return X;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.UP : Facing.DOWN;
        }

        @Override
        public class_2350.class_2351 toVanilla() {
            return class_2350.class_2351.field_11052;
        }

        @Override
        public class_2382 mirror(class_2382 vec) {
            return new class_2382(vec.method_10263(), -vec.method_10264(), vec.method_10260());
        }

        @Override
        public class_2338 mirror(class_2338 vec) {
            return new class_2338(vec.method_10263(), -vec.method_10264(), vec.method_10260());
        }
    }
    ,
    Z{

        @Override
        public double get(double x, double y, double z) {
            return z;
        }

        @Override
        public float get(float x, float y, float z) {
            return z;
        }

        @Override
        public int get(int x, int y, int z) {
            return z;
        }

        @Override
        public <T> T get(T x, T y, T z) {
            return z;
        }

        @Override
        public Axis one() {
            return X;
        }

        @Override
        public Axis two() {
            return Y;
        }

        @Override
        public Facing facing(boolean positive) {
            return positive ? Facing.SOUTH : Facing.NORTH;
        }

        @Override
        public class_2350.class_2351 toVanilla() {
            return class_2350.class_2351.field_11051;
        }

        @Override
        public class_2382 mirror(class_2382 vec) {
            return new class_2382(vec.method_10263(), vec.method_10264(), -vec.method_10260());
        }

        @Override
        public class_2338 mirror(class_2338 vec) {
            return new class_2338(vec.method_10263(), vec.method_10264(), -vec.method_10260());
        }
    };


    public static Axis get(class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return X;
            }
            case field_11052: {
                return Y;
            }
            case field_11051: {
                return Z;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Axis third(Axis one, Axis two) {
        switch (one) {
            case X: {
                if (two == Y) {
                    return Z;
                }
                return Y;
            }
            case Y: {
                if (two == X) {
                    return Z;
                }
                return X;
            }
            case Z: {
                if (two == Y) {
                    return X;
                }
                return Y;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Axis getMirrorAxis(class_2415 mirrorIn) {
        switch (mirrorIn) {
            case field_11301: {
                return X;
            }
            case field_11300: {
                return Z;
            }
        }
        return null;
    }

    public abstract Axis one();

    public abstract Axis two();

    public abstract Facing facing(boolean var1);

    public abstract double get(double var1, double var3, double var5);

    public abstract float get(float var1, float var2, float var3);

    public abstract int get(int var1, int var2, int var3);

    public abstract <T> T get(T var1, T var2, T var3);

    public abstract class_2350.class_2351 toVanilla();

    public Facing mirror(Facing facing) {
        if (facing.axis == this) {
            return facing.opposite();
        }
        return facing;
    }

    public class_2350 mirror(class_2350 facing) {
        if (facing.method_10166() == this.toVanilla()) {
            return facing.method_10153();
        }
        return facing;
    }

    public abstract class_2382 mirror(class_2382 var1);

    public abstract class_2338 mirror(class_2338 var1);

    public void mirror(Vec3d vec) {
        vec.set(this, -vec.get(this));
    }

    public void mirror(Vec3f vec) {
        vec.set(this, -vec.get(this));
    }
}

