/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import net.minecraft.class_2338;
import net.minecraft.class_238;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class CreativeAABB
extends class_238 {
    public CreativeAABB(double x1, double y1, double z1, double x2, double y2, double z2) {
        super(x1, y1, z1, x2, y2, z2);
    }

    public CreativeAABB(class_2338 pos) {
        super(pos);
    }

    public CreativeAABB(class_2338 pos1, class_2338 pos2) {
        super(pos1, pos2);
    }

    public boolean contains(Vec3d vec) {
        if (vec.x > this.field_1323 && vec.x < this.field_1320) {
            if (vec.y > this.field_1322 && vec.y < this.field_1325) {
                return vec.z > this.field_1321 && vec.z < this.field_1324;
            }
            return false;
        }
        return false;
    }

    protected double get(Facing facing) {
        switch (facing) {
            case EAST: {
                return this.field_1320;
            }
            case WEST: {
                return this.field_1323;
            }
            case UP: {
                return this.field_1325;
            }
            case DOWN: {
                return this.field_1322;
            }
            case SOUTH: {
                return this.field_1324;
            }
            case NORTH: {
                return this.field_1321;
            }
        }
        return 0.0;
    }

    public Vec3d getCorner(BoxCorner corner) {
        return new Vec3d(this.getCornerX(corner), this.getCornerY(corner), this.getCornerZ(corner));
    }

    public double getCornerValue(BoxCorner corner, Axis axis) {
        return this.get(corner.getFacing(axis));
    }

    public double getCornerX(BoxCorner corner) {
        return this.get(corner.x);
    }

    public double getCornerY(BoxCorner corner) {
        return this.get(corner.y);
    }

    public double getCornerZ(BoxCorner corner) {
        return this.get(corner.z);
    }

    public Vec3d getSizeVec() {
        return new Vec3d(this.field_1320 - this.field_1323, this.field_1325 - this.field_1322, this.field_1324 - this.field_1321);
    }

    public double getVolume() {
        return (this.field_1320 - this.field_1323) * (this.field_1325 - this.field_1322) * (this.field_1324 - this.field_1321);
    }

    public double getIntersectionVolume(class_238 other) {
        double d0 = Math.max(this.field_1323, other.field_1323);
        double d1 = Math.max(this.field_1322, other.field_1322);
        double d2 = Math.max(this.field_1321, other.field_1321);
        double d3 = Math.min(this.field_1320, other.field_1320);
        double d4 = Math.min(this.field_1325, other.field_1325);
        double d5 = Math.min(this.field_1324, other.field_1324);
        if (d0 < d3 && d1 < d4 && d2 < d5) {
            return Math.abs((d3 - d0) * (d4 - d1) * (d5 - d2));
        }
        return 0.0;
    }

    public double getSize(Axis axis) {
        switch (axis) {
            case X: {
                return this.field_1320 - this.field_1323;
            }
            case Y: {
                return this.field_1325 - this.field_1322;
            }
            case Z: {
                return this.field_1324 - this.field_1321;
            }
        }
        return 0.0;
    }

    public double getMin(Axis axis) {
        switch (axis) {
            case X: {
                return this.field_1323;
            }
            case Y: {
                return this.field_1322;
            }
            case Z: {
                return this.field_1321;
            }
        }
        return 0.0;
    }

    public double getMax(Axis axis) {
        switch (axis) {
            case X: {
                return this.field_1320;
            }
            case Y: {
                return this.field_1325;
            }
            case Z: {
                return this.field_1324;
            }
        }
        return 0.0;
    }

    public static double get(class_238 bb, Facing facing) {
        switch (facing) {
            case EAST: {
                return bb.field_1320;
            }
            case WEST: {
                return bb.field_1323;
            }
            case UP: {
                return bb.field_1325;
            }
            case DOWN: {
                return bb.field_1322;
            }
            case SOUTH: {
                return bb.field_1324;
            }
            case NORTH: {
                return bb.field_1321;
            }
        }
        return 0.0;
    }

    public static double getMin(class_238 bb, Axis axis) {
        switch (axis) {
            case X: {
                return bb.field_1323;
            }
            case Y: {
                return bb.field_1322;
            }
            case Z: {
                return bb.field_1321;
            }
        }
        return 0.0;
    }

    public static double getMax(class_238 bb, Axis axis) {
        switch (axis) {
            case X: {
                return bb.field_1320;
            }
            case Y: {
                return bb.field_1325;
            }
            case Z: {
                return bb.field_1324;
            }
        }
        return 0.0;
    }

    public static Vec3d getCorner(class_238 bb, BoxCorner corner) {
        return new Vec3d(CreativeAABB.getCornerX(bb, corner), CreativeAABB.getCornerY(bb, corner), CreativeAABB.getCornerZ(bb, corner));
    }

    public static double getCornerValue(class_238 bb, BoxCorner corner, Axis axis) {
        return CreativeAABB.get(bb, corner.getFacing(axis));
    }

    public static double getCornerX(class_238 bb, BoxCorner corner) {
        return CreativeAABB.get(bb, corner.x);
    }

    public static double getCornerY(class_238 bb, BoxCorner corner) {
        return CreativeAABB.get(bb, corner.y);
    }

    public static double getCornerZ(class_238 bb, BoxCorner corner) {
        return CreativeAABB.get(bb, corner.z);
    }
}

