/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.parent.GuiColumn;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;

public class GuiListBoxBase<T extends GuiControl>
extends GuiScrollY {
    protected List<GuiRow> rows = new ArrayList<GuiRow>();
    protected List<T> content;
    protected int cachedWidth;
    protected int cachedHeight;
    public final boolean modifiable;

    public GuiListBoxBase(String name, boolean modifiable, List<T> entries) {
        super(name);
        this.content = entries;
        this.modifiable = modifiable;
        this.createItems();
    }

    protected void createItems() {
        for (int i = 0; i < this.content.size(); ++i) {
            this.createControl(i);
        }
    }

    protected void createControl(int index) {
        GuiRow row = new GuiRow();
        super.add(row);
        GuiColumn content = (GuiColumn)new GuiColumn().setExpandableX();
        content.align = Align.CENTER;
        content.add((GuiControl)this.content.get(index));
        row.addColumn(content);
        if (this.modifiable) {
            GuiColumn remove = new GuiColumn(20);
            remove.align = Align.CENTER;
            remove.add(new GuiButtonRemove(index));
            row.addColumn(remove);
        }
        this.rows.add(row);
    }

    protected void removeControl(int index) {
        this.remove(this.rows.get(index));
        this.rows.remove(index);
        this.content.remove(index);
    }

    protected GuiChildControl addCustomControl(GuiControl control) {
        return super.add(control);
    }

    @Override
    @Deprecated
    public GuiChildControl add(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GuiChildControl addHover(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedWidth = width;
        super.flowX(width, preferred);
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        this.cachedHeight = height;
        super.flowY(width, height, preferred);
    }

    public void reflowInternal() {
        if (this.hasGui()) {
            super.flowX(this.cachedWidth, this.preferredWidth(this.cachedWidth));
            super.flowY(this.cachedWidth, this.cachedHeight, this.preferredHeight(this.cachedWidth, this.cachedHeight));
        }
    }

    public void removeItem(int index) {
        this.removeControl(index);
        if (this.modifiable) {
            for (int i = 0; i < this.rows.size(); ++i) {
                ((GuiButtonRemove)this.rows.get((int)i).getCol((int)1).get((String)"x")).index = i;
            }
        }
        this.reflowInternal();
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    public void clearItems() {
        while (this.content.size() > 0) {
            this.removeControl(this.content.size() - 1);
        }
    }

    public void addAllItems(List<T> entries) {
        for (GuiControl entry : entries) {
            this.content.add(entry);
            this.createControl(this.content.size() - 1);
        }
        this.reflowInternal();
    }

    public void addItem(T entry) {
        this.content.add(entry);
        this.createControl(this.content.size() - 1);
        this.reflowInternal();
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public int size() {
        return this.content.size();
    }

    public T get(int index) {
        return (T)((GuiControl)this.content.get(index));
    }

    public class GuiButtonRemove
    extends GuiButton {
        public int index;

        public GuiButtonRemove(int index) {
            super("x", null);
            this.setDim(6, 8);
            this.setAlign(Align.CENTER);
            this.setTitle((Component)Component.m_237113_((String)"x"));
            this.pressed = x -> GuiListBoxBase.this.removeItem(this.index);
            this.index = index;
        }
    }
}

