/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import net.minecraft.util.Mth;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonHoldSlim;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiCounterDecimal
extends GuiParent {
    public float min;
    public float max;
    public GuiTextfield textfield;

    public GuiCounterDecimal(String name, float value) {
        this(name, value, Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public GuiCounterDecimal(String name, float value, float min, float max) {
        super(name);
        this.min = min;
        this.max = max;
        this.flow = GuiFlow.STACK_X;
        this.spacing = 1;
        this.textfield = new GuiTextfield("value", "" + Mth.m_14036_((float)value, (float)min, (float)max)).setDim(20, 10).setFloatOnly();
        this.add(this.textfield.setExpandableX());
        GuiParent buttons = new GuiParent(GuiFlow.STACK_Y);
        buttons.spacing = 0;
        this.add(buttons);
        buttons.add(new GuiButtonHoldSlim("+", x -> {
            this.textfield.setText("" + this.stepUp(this.textfield.parseFloat()));
            this.raiseEvent(new GuiControlChangedEvent(this));
        }).setTranslate("gui.plus").setDim(6, 3));
        buttons.add(new GuiButtonHoldSlim("-", x -> {
            this.textfield.setText("" + this.stepDown(this.textfield.parseFloat()));
            this.raiseEvent(new GuiControlChangedEvent(this));
        }).setTranslate("gui.minus").setDim(6, 3));
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    public void resetTextfield() {
        this.textfield.setCursorPositionZero();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void raiseEvent(GuiEvent event) {
        if (event instanceof GuiControlChangedEvent) {
            GuiControlChangedEvent controlEvent = (GuiControlChangedEvent)event;
            if (controlEvent.control.is("value")) {
                super.raiseEvent(new GuiControlChangedEvent(this));
                return;
            }
        }
        super.raiseEvent(event);
    }

    @Override
    public boolean isExpandableX() {
        return this.expandableX;
    }

    public float stepUp(float value) {
        return Math.min(this.max, value + 1.0f);
    }

    public float stepDown(float value) {
        return Math.max(this.min, value - 1.0f);
    }

    public float getValue() {
        return Mth.m_14036_((float)this.textfield.parseFloat(), (float)this.min, (float)this.max);
    }

    public void setValue(float value) {
        this.textfield.setText("" + Mth.m_14036_((float)value, (float)this.min, (float)this.max));
    }
}

