/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.flow;

import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.type.list.MarkList;

public class GuiStackX
extends GuiFlow {
    @Override
    public int minWidth(List<GuiChildControl> controls, int spacing, int availableWidth) {
        boolean has = false;
        int width = -spacing;
        for (GuiChildControl child : controls) {
            int min = child.getMinWidth(availableWidth);
            if (min != -1) {
                width += min;
                has = true;
            }
            width += spacing;
        }
        return has ? width : -1;
    }

    @Override
    public int preferredWidth(List<GuiChildControl> controls, int spacing, int availableWidth) {
        int width = -spacing;
        for (GuiChildControl child : controls) {
            width += child.getPreferredWidth(availableWidth) + spacing;
        }
        return width;
    }

    @Override
    public int minHeight(List<GuiChildControl> controls, int spacing, int width, int availableHeight) {
        int height = -1;
        for (GuiChildControl child : controls) {
            height = Math.max(height, child.getMinHeight(availableHeight));
        }
        return height;
    }

    @Override
    public int preferredHeight(List<GuiChildControl> controls, int spacing, int width, int availableHeight) {
        int height = 0;
        for (GuiChildControl child : controls) {
            height = Math.max(height, child.getPreferredHeight(availableHeight));
        }
        return height;
    }

    @Override
    public void flowX(List<GuiChildControl> controls, int spacing, Align align, int width, int preferred, boolean endless) {
        block30: {
            int available;
            block31: {
                block29: {
                    available = width - spacing * (controls.size() - 1);
                    MarkList<GuiChildControl> list = new MarkList<GuiChildControl>(controls);
                    if (width >= preferred) {
                        if (align == Align.STRETCH && !GuiStackX.areChildrenExpandableX(controls)) {
                            for (GuiChildControl child : list) {
                                int min = child.getMinWidth(width);
                                if (min != -1) {
                                    available -= min;
                                    child.setWidth(min, width);
                                    continue;
                                }
                                child.setWidth(0, width);
                            }
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                itr = list.iterator();
                                while (itr.hasNext()) {
                                    GuiChildControl child = (GuiChildControl)itr.next();
                                    int toAdd = Maths.min(average, available, child.getPreferredWidth(width) - child.getWidth());
                                    if (toAdd <= 0) {
                                        itr.mark();
                                        continue;
                                    }
                                    available -= child.addWidth(toAdd, width);
                                    if (!child.isMaxWidth(width)) continue;
                                    itr.mark();
                                }
                            }
                            list.clear();
                            while (available > 0 && !list.isEmpty()) {
                                int average = (int)Math.ceil((double)available / (double)list.remaing());
                                itr = list.iterator();
                                while (itr.hasNext()) {
                                    GuiChildControl child = (GuiChildControl)itr.next();
                                    available -= child.addWidth(Math.min(average, available), width);
                                    if (!child.isMaxWidth(width)) continue;
                                    itr.mark();
                                }
                            }
                        } else {
                            Iterator itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiChildControl child;
                                child = (GuiChildControl)itr.next();
                                child.setWidth(child.getPreferredWidth(width), width);
                                if (!child.isExpandableX()) {
                                    itr.mark();
                                }
                                available -= child.getWidth();
                            }
                            if (align == Align.STRETCH || GuiStackX.areChildrenExpandableX(controls)) {
                                while (available > 0 && !list.isEmpty()) {
                                    int average = (int)Math.ceil((double)available / (double)list.remaing());
                                    itr = list.iterator();
                                    while (itr.hasNext()) {
                                        GuiChildControl child = (GuiChildControl)itr.next();
                                        available -= child.addWidth(Math.min(average, available), width);
                                        if (!child.isMaxWidth(width)) continue;
                                        itr.mark();
                                    }
                                }
                            }
                        }
                    } else if (endless) {
                        for (GuiChildControl child : controls) {
                            child.setWidth(child.getPreferredWidth(width), width);
                        }
                        align = Align.LEFT;
                    } else {
                        for (GuiChildControl child : list) {
                            int min = child.getMinWidth(width);
                            if (min != -1) {
                                available -= min;
                                child.setWidth(min, width);
                                continue;
                            }
                            child.setWidth(0, width);
                        }
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiChildControl child = (GuiChildControl)itr.next();
                                int prefer = child.getPreferredWidth(width);
                                available -= child.addWidth(Math.min(average, Math.min(prefer - child.getWidth(), available)), width);
                                if (!child.isMaxWidth(width) && prefer > child.getWidth()) continue;
                                itr.mark();
                            }
                        }
                        list.clear();
                        while (available > 0 && !list.isEmpty()) {
                            int average = (int)Math.ceil((double)available / (double)list.remaing());
                            itr = list.iterator();
                            while (itr.hasNext()) {
                                GuiChildControl child = (GuiChildControl)itr.next();
                                available -= child.addWidth(Math.min(average, available), width);
                                if (!child.isMaxWidth(width)) continue;
                                itr.mark();
                            }
                        }
                    }
                    for (GuiChildControl child : controls) {
                        child.flowX();
                    }
                    if (available > 0 && align != Align.LEFT) break block29;
                    int x = 0;
                    for (GuiChildControl child : controls) {
                        child.setX(x);
                        x += child.getWidth() + spacing;
                    }
                    break block30;
                }
                if (align != Align.RIGHT) break block31;
                int x = width;
                for (GuiChildControl child : controls) {
                    child.setX(x -= child.getWidth());
                    x -= spacing;
                }
                break block30;
            }
            if (align != Align.CENTER && align != Align.STRETCH) break block30;
            int x = available / 2;
            for (GuiChildControl child : controls) {
                child.setX(x);
                x += child.getWidth() + spacing;
            }
        }
    }

    @Override
    public void flowY(List<GuiChildControl> controls, int spacing, VAlign valign, int width, int height, int preferred, boolean endless) {
        int maxHeight = height;
        if (endless && preferred > height) {
            maxHeight = preferred;
        }
        boolean expandable = GuiStackX.areChildrenExpandableY(controls);
        if (valign == VAlign.TOP && !expandable) {
            for (GuiChildControl child : controls) {
                child.setY(0);
                child.setHeight(Math.min(maxHeight, child.getPreferredHeight(height)), height);
                child.flowY();
            }
        } else if (valign == VAlign.STRETCH || expandable) {
            for (GuiChildControl child : controls) {
                if (child.isExpandableY() || valign == VAlign.STRETCH) {
                    child.setHeight(maxHeight, height);
                } else {
                    child.setHeight(Math.min(maxHeight, child.getPreferredHeight(height)), height);
                }
                child.setY(0);
                child.flowY();
            }
        } else if (valign == VAlign.BOTTOM) {
            for (GuiChildControl child : controls) {
                child.setHeight(Math.min(maxHeight, child.getPreferredHeight(height)), height);
                child.setY(maxHeight - child.getHeight());
                child.flowY();
            }
        } else {
            for (GuiChildControl child : controls) {
                child.setHeight(Math.min(maxHeight, child.getPreferredHeight(height)), height);
                child.setY((int)Math.ceil((double)maxHeight / 2.0 - (double)child.getHeight() / 2.0));
                child.flowY();
            }
        }
    }
}

