/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.style.display;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.Color;

@OnlyIn(value=Dist.CLIENT)
public class DisplayColor
extends StyleDisplay {
    public float alpha;
    public float red;
    public float green;
    public float blue;

    public DisplayColor() {
        this.set(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public DisplayColor(int color) {
        this.set(ColorUtils.redF(color), ColorUtils.greenF(color), ColorUtils.blueF(color), ColorUtils.alphaF(color));
    }

    public DisplayColor(float r, float g, float b, float a) {
        this.set(r, g, b, a);
    }

    public DisplayColor(Color color) {
        this.set(color.getRedDecimal(), color.getGreenDecimal(), color.getBlueDecimal(), color.getAlphaDecimal());
    }

    public void set(int color) {
        this.set(ColorUtils.redF(color), ColorUtils.greenF(color), ColorUtils.blueF(color), ColorUtils.alphaF(color));
    }

    public void set(float r, float g, float b, float a) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
    }

    public void set(Color color) {
        this.set(color.getRedDecimal(), color.getGreenDecimal(), color.getBlueDecimal(), color.getAlphaDecimal());
    }

    @Override
    public void render(PoseStack pose, double x, double y, double width, double height) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f mat = pose.m_85850_().m_252922_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(mat, (float)(x + width), (float)y, 0.0f).m_85950_(this.red, this.green, this.blue, this.alpha).m_5752_();
        buffer.m_252986_(mat, (float)x, (float)y, 0.0f).m_85950_(this.red, this.green, this.blue, this.alpha).m_5752_();
        buffer.m_252986_(mat, (float)x, (float)(y + height), 0.0f).m_85950_(this.red, this.green, this.blue, this.alpha).m_5752_();
        buffer.m_252986_(mat, (float)(x + width), (float)(y + height), 0.0f).m_85950_(this.red, this.green, this.blue, this.alpha).m_5752_();
        tessellator.m_85914_();
    }
}

