/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network.type;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3f;
import team.creative.creativecore.common.network.type.NetworkFieldType;
import team.creative.creativecore.common.network.type.NetworkFieldTypeClass;
import team.creative.creativecore.common.network.type.NetworkFieldTypeSpecial;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.filter.Filter;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec1f;
import team.creative.creativecore.common.util.math.vec.Vec2d;
import team.creative.creativecore.common.util.math.vec.Vec2f;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.registry.exception.RegistryException;
import team.creative.creativecore.common.util.text.AdvancedComponentHelper;
import team.creative.creativecore.common.util.type.Bunch;

public class NetworkFieldTypes {
    private static final Gson GSON = new Gson();
    private static final List<NetworkFieldTypeSpecial> specialParsers = new ArrayList<NetworkFieldTypeSpecial>();
    private static final HashMap<Class, NetworkFieldTypeClass> parsers = new HashMap();

    public static <T> void register(NetworkFieldTypeClass<T> parser, Class<T> classType) {
        parsers.put(classType, parser);
    }

    public static <T> void register(NetworkFieldTypeClass<T> parser, Class<? extends T> ... classType) {
        for (Class<? extends T> clazz : classType) {
            parsers.put(clazz, parser);
        }
    }

    public static <T> void register(NetworkFieldTypeSpecial parser) {
        specialParsers.add(parser);
    }

    public static NetworkFieldType get(Field field) {
        return NetworkFieldTypes.get(field.getType(), field.getGenericType());
    }

    public static <T> NetworkFieldType<T> get(Class<T> classType) {
        try {
            NetworkFieldType parser = parsers.get(classType);
            if (parser != null) {
                return parser;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        throw new RuntimeException("No field type found for " + classType.getSimpleName());
    }

    public static NetworkFieldType get(Class classType, Type genericType) {
        try {
            NetworkFieldType parser = parsers.get(classType);
            if (parser != null) {
                return parser;
            }
            for (int i = 0; i < specialParsers.size(); ++i) {
                if (!NetworkFieldTypes.specialParsers.get((int)i).predicate.test(classType, genericType)) continue;
                return specialParsers.get(i);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        throw new RuntimeException("No field type found for " + classType.getSimpleName());
    }

    public static <T> void write(Class<T> clazz, T object, FriendlyByteBuf buffer) {
        NetworkFieldTypes.get(clazz).write(object, clazz, null, buffer);
    }

    public static <T> void writeMany(Class<T> clazz, Bunch<T> bunch, FriendlyByteBuf buffer) {
        buffer.writeInt(bunch.size());
        NetworkFieldType type = NetworkFieldTypes.get(clazz);
        for (Object t : bunch) {
            type.write(t, clazz, null, buffer);
        }
    }

    public static <T> void writeMany(Class<T> clazz, Collection<T> collection, FriendlyByteBuf buffer) {
        buffer.writeInt(collection.size());
        NetworkFieldType<T> type = NetworkFieldTypes.get(clazz);
        for (T t : collection) {
            type.write(t, clazz, null, buffer);
        }
    }

    public static <T> void writeMany(Class<T> clazz, T[] collection, FriendlyByteBuf buffer) {
        buffer.writeInt(collection.length);
        NetworkFieldType<T> type = NetworkFieldTypes.get(clazz);
        for (T t : collection) {
            type.write(t, clazz, null, buffer);
        }
    }

    public static <T> T read(Class<T> clazz, FriendlyByteBuf buffer) {
        return NetworkFieldTypes.get(clazz).read(clazz, null, buffer);
    }

    public static <T> Iterable<T> readMany(final Class<T> clazz, final FriendlyByteBuf buffer) {
        final int length = buffer.readInt();
        final NetworkFieldType type = NetworkFieldTypes.get(clazz);
        return () -> new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < length;
            }

            @Override
            public T next() {
                ++this.index;
                return type.read(clazz, null, buffer);
            }
        };
    }

    static {
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Boolean>(){

            @Override
            protected void writeContent(Boolean content, FriendlyByteBuf buffer) {
                buffer.writeBoolean(content.booleanValue());
            }

            @Override
            protected Boolean readContent(FriendlyByteBuf buffer) {
                return buffer.readBoolean();
            }
        }, Boolean.TYPE, Boolean.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Byte>(){

            @Override
            protected void writeContent(Byte content, FriendlyByteBuf buffer) {
                buffer.writeByte((int)content.byteValue());
            }

            @Override
            protected Byte readContent(FriendlyByteBuf buffer) {
                return buffer.readByte();
            }
        }, Byte.TYPE, Byte.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Short>(){

            @Override
            protected void writeContent(Short content, FriendlyByteBuf buffer) {
                buffer.writeShort((int)content.shortValue());
            }

            @Override
            protected Short readContent(FriendlyByteBuf buffer) {
                return buffer.readShort();
            }
        }, Short.TYPE, Short.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Integer>(){

            @Override
            protected void writeContent(Integer content, FriendlyByteBuf buffer) {
                buffer.writeInt(content.intValue());
            }

            @Override
            protected Integer readContent(FriendlyByteBuf buffer) {
                return buffer.readInt();
            }
        }, Integer.TYPE, Integer.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Long>(){

            @Override
            protected void writeContent(Long content, FriendlyByteBuf buffer) {
                buffer.writeLong(content.longValue());
            }

            @Override
            protected Long readContent(FriendlyByteBuf buffer) {
                return buffer.readLong();
            }
        }, Long.TYPE, Long.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Float>(){

            @Override
            protected void writeContent(Float content, FriendlyByteBuf buffer) {
                buffer.writeFloat(content.floatValue());
            }

            @Override
            protected Float readContent(FriendlyByteBuf buffer) {
                return Float.valueOf(buffer.readFloat());
            }
        }, Float.TYPE, Float.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Double>(){

            @Override
            protected void writeContent(Double content, FriendlyByteBuf buffer) {
                buffer.writeDouble(content.doubleValue());
            }

            @Override
            protected Double readContent(FriendlyByteBuf buffer) {
                return buffer.readDouble();
            }
        }, Double.TYPE, Double.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<BlockPos>(){

            @Override
            protected void writeContent(BlockPos content, FriendlyByteBuf buffer) {
                buffer.m_130064_(content);
            }

            @Override
            protected BlockPos readContent(FriendlyByteBuf buffer) {
                return buffer.m_130135_();
            }
        }, BlockPos.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<String>(){

            @Override
            protected void writeContent(String content, FriendlyByteBuf buffer) {
                buffer.m_130070_(content);
            }

            @Override
            protected String readContent(FriendlyByteBuf buffer) {
                return buffer.m_130136_(Short.MAX_VALUE);
            }
        }, String.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Component>(){

            @Override
            protected void writeContent(Component content, FriendlyByteBuf buffer) {
                buffer.m_130083_(content);
            }

            @Override
            protected Component readContent(FriendlyByteBuf buffer) {
                return buffer.m_130238_();
            }
        }, Component.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<CompoundTag>(){

            @Override
            protected void writeContent(CompoundTag content, FriendlyByteBuf buffer) {
                buffer.m_130079_(content);
            }

            @Override
            protected CompoundTag readContent(FriendlyByteBuf buffer) {
                return buffer.m_130260_();
            }
        }, CompoundTag.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<ItemStack>(){

            @Override
            protected void writeContent(ItemStack content, FriendlyByteBuf buffer) {
                buffer.m_130055_(content);
            }

            @Override
            protected ItemStack readContent(FriendlyByteBuf buffer) {
                return buffer.m_130267_();
            }
        }, ItemStack.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<ResourceLocation>(){

            @Override
            protected void writeContent(ResourceLocation content, FriendlyByteBuf buffer) {
                buffer.m_130085_(content);
            }

            @Override
            protected ResourceLocation readContent(FriendlyByteBuf buffer) {
                return buffer.m_130281_();
            }
        }, ResourceLocation.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<BlockState>(){

            @Override
            protected void writeContent(BlockState content, FriendlyByteBuf buffer) {
                buffer.writeInt(Block.m_49956_((BlockState)content));
            }

            @Override
            protected BlockState readContent(FriendlyByteBuf buffer) {
                return Block.m_49803_((int)buffer.readInt());
            }
        }, BlockState.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Block>(){

            @Override
            protected void writeContent(Block content, FriendlyByteBuf buffer) {
                buffer.m_130085_(BuiltInRegistries.f_256975_.m_7981_((Object)content));
            }

            @Override
            protected Block readContent(FriendlyByteBuf buffer) {
                return (Block)BuiltInRegistries.f_256975_.m_7745_(buffer.m_130281_());
            }
        }, Block.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Item>(){

            @Override
            protected void writeContent(Item content, FriendlyByteBuf buffer) {
                buffer.m_130085_(BuiltInRegistries.f_257033_.m_7981_((Object)content));
            }

            @Override
            protected Item readContent(FriendlyByteBuf buffer) {
                return (Item)BuiltInRegistries.f_257033_.m_7745_(buffer.m_130281_());
            }
        }, Item.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vector3d>(){

            @Override
            protected void writeContent(Vector3d content, FriendlyByteBuf buffer) {
                buffer.writeDouble(content.x);
                buffer.writeDouble(content.y);
                buffer.writeDouble(content.z);
            }

            @Override
            protected Vector3d readContent(FriendlyByteBuf buffer) {
                return new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, Vector3d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec3>(){

            @Override
            protected void writeContent(Vec3 content, FriendlyByteBuf buffer) {
                buffer.writeDouble(content.f_82479_);
                buffer.writeDouble(content.f_82480_);
                buffer.writeDouble(content.f_82481_);
            }

            @Override
            protected Vec3 readContent(FriendlyByteBuf buffer) {
                return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, Vec3.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec1d>(){

            @Override
            protected void writeContent(Vec1d content, FriendlyByteBuf buffer) {
                buffer.writeDouble(content.x);
            }

            @Override
            protected Vec1d readContent(FriendlyByteBuf buffer) {
                return new Vec1d(buffer.readDouble());
            }
        }, Vec1d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec1f>(){

            @Override
            protected void writeContent(Vec1f content, FriendlyByteBuf buffer) {
                buffer.writeFloat(content.x);
            }

            @Override
            protected Vec1f readContent(FriendlyByteBuf buffer) {
                return new Vec1f(buffer.readFloat());
            }
        }, Vec1f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec2d>(){

            @Override
            protected void writeContent(Vec2d content, FriendlyByteBuf buffer) {
                buffer.writeDouble(content.x);
                buffer.writeDouble(content.y);
            }

            @Override
            protected Vec2d readContent(FriendlyByteBuf buffer) {
                return new Vec2d(buffer.readDouble(), buffer.readDouble());
            }
        }, Vec2d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec2f>(){

            @Override
            protected void writeContent(Vec2f content, FriendlyByteBuf buffer) {
                buffer.writeFloat(content.x);
                buffer.writeFloat(content.y);
            }

            @Override
            protected Vec2f readContent(FriendlyByteBuf buffer) {
                return new Vec2f(buffer.readFloat(), buffer.readFloat());
            }
        }, Vec2f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec3d>(){

            @Override
            protected void writeContent(Vec3d content, FriendlyByteBuf buffer) {
                buffer.writeDouble(content.x);
                buffer.writeDouble(content.y);
                buffer.writeDouble(content.z);
            }

            @Override
            protected Vec3d readContent(FriendlyByteBuf buffer) {
                return new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, Vec3d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec3f>(){

            @Override
            protected void writeContent(Vec3f content, FriendlyByteBuf buffer) {
                buffer.writeFloat(content.x);
                buffer.writeFloat(content.y);
                buffer.writeFloat(content.z);
            }

            @Override
            protected Vec3f readContent(FriendlyByteBuf buffer) {
                return new Vec3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        }, Vec3f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vector3f>(){

            @Override
            protected void writeContent(Vector3f content, FriendlyByteBuf buffer) {
                buffer.writeFloat(content.x());
                buffer.writeFloat(content.y());
                buffer.writeFloat(content.z());
            }

            @Override
            protected Vector3f readContent(FriendlyByteBuf buffer) {
                return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        }, Vector3f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<UUID>(){

            @Override
            protected void writeContent(UUID content, FriendlyByteBuf buffer) {
                buffer.m_130070_(content.toString());
            }

            @Override
            protected UUID readContent(FriendlyByteBuf buffer) {
                return UUID.fromString(buffer.m_130136_(Short.MAX_VALUE));
            }
        }, UUID.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<JsonObject>(){

            @Override
            protected void writeContent(JsonObject content, FriendlyByteBuf buffer) {
                buffer.m_130070_(content.toString());
            }

            @Override
            protected JsonObject readContent(FriendlyByteBuf buffer) {
                return (JsonObject)GSON.fromJson(buffer.m_130136_(Short.MAX_VALUE), JsonObject.class);
            }
        }, JsonObject.class);
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial((x, y) -> x.isArray()){

            @Override
            public void write(Object content, Class classType, Type genericType, FriendlyByteBuf buffer) {
                Class<?> subClass = classType.getComponentType();
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, null);
                int length = Array.getLength(content);
                buffer.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(Array.get(content, i), subClass, null, buffer);
                }
            }

            @Override
            public Object read(Class classType, Type genericType, FriendlyByteBuf buffer) {
                int length = buffer.readInt();
                Class<?> subClass = classType.getComponentType();
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, null);
                Object object = Array.newInstance(subClass, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(object, i, subParser.read(subClass, null, buffer));
                }
                return object;
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial((x, y) -> x.equals(ArrayList.class) || x.equals(List.class)){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void write(Object content, Class classType, Type genericType, FriendlyByteBuf buffer) {
                Type subType;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Class subClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, subType = types[0]);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = ((List)content).size();
                buffer.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(((List)content).get(i), subClass, subType, buffer);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object read(Class classType, Type genericType, FriendlyByteBuf buffer) {
                Type subType;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Class subClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, subType = types[0]);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = buffer.readInt();
                ArrayList list = new ArrayList(length);
                for (int j = 0; j < length; ++j) {
                    list.add(subParser.read(subClass, subType, buffer));
                }
                return list;
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial((x, y) -> x.isEnum()){

            @Override
            public void write(Object content, Class classType, Type genericType, FriendlyByteBuf buffer) {
                buffer.m_130068_((Enum)content);
            }

            @Override
            public Object read(Class classType, Type genericType, FriendlyByteBuf buffer) {
                return buffer.m_130066_(classType);
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Filter>(){

            @Override
            protected void writeContent(Filter content, FriendlyByteBuf buffer) {
                try {
                    buffer.m_130079_(Filter.SERIALIZER.write(content));
                }
                catch (RegistryException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected Filter readContent(FriendlyByteBuf buffer) {
                try {
                    return Filter.SERIALIZER.read(buffer.m_130261_());
                }
                catch (RegistryException e) {
                    e.printStackTrace();
                    return Filter.or(new Filter[0]);
                }
            }
        }, Filter.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<BiFilter>(){

            @Override
            protected void writeContent(BiFilter content, FriendlyByteBuf buffer) {
                try {
                    buffer.m_130079_(BiFilter.SERIALIZER.write(content));
                }
                catch (RegistryException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected BiFilter readContent(FriendlyByteBuf buffer) {
                try {
                    return BiFilter.SERIALIZER.read(buffer.m_130261_());
                }
                catch (RegistryException e) {
                    e.printStackTrace();
                    return BiFilter.or(new BiFilter[0]);
                }
            }
        }, BiFilter.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Component>(){
            private static final Gson GSON = (Gson)Util.m_137537_(() -> {
                GsonBuilder gsonbuilder = new GsonBuilder();
                gsonbuilder.disableHtmlEscaping();
                gsonbuilder.registerTypeHierarchyAdapter(Component.class, (Object)new AdvancedComponentHelper.Serializer());
                gsonbuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
                gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
                return gsonbuilder.create();
            });

            @Override
            protected void writeContent(Component content, FriendlyByteBuf buffer) {
                buffer.m_130070_(GSON.toJson((Object)content));
            }

            @Override
            protected Component readContent(FriendlyByteBuf buffer) {
                return (Component)GsonHelper.m_263467_((Gson)GSON, (String)buffer.m_130277_(), MutableComponent.class, (boolean)false);
            }
        }, Component.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Tag>(){

            @Override
            protected void writeContent(Tag content, FriendlyByteBuf buffer) {
                buffer.writeByte((int)content.m_7060_());
                if (content.m_7060_() != 0) {
                    try {
                        content.m_6434_((DataOutput)new ByteBufOutputStream((ByteBuf)buffer));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            @Override
            protected Tag readContent(FriendlyByteBuf buffer) {
                ByteBufInputStream in = new ByteBufInputStream((ByteBuf)buffer);
                try {
                    byte b0 = in.readByte();
                    if (b0 == 0) {
                        return EndTag.f_128534_;
                    }
                    return TagTypes.m_129397_((int)b0).m_7300_((DataInput)in, 0, NbtAccounter.f_128917_);
                }
                catch (IOException e) {
                    CrashReport crashreport = CrashReport.m_127521_((Throwable)e, (String)"Loading NBT data");
                    crashreport.m_127514_("NBT Tag");
                    throw new ReportedException(crashreport);
                }
            }
        }, Tag.class);
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial((x, y) -> Packet.class.isAssignableFrom((Class<?>)x)){
            public static final int BUNDLE_WILDCARD = 234920940;

            @Override
            public void write(Object content, Class classType, Type genericType, FriendlyByteBuf buffer) {
                Packet packet = (Packet)content;
                ConnectionProtocol protocol = ConnectionProtocol.m_129592_((Packet)packet);
                if (protocol != ConnectionProtocol.PLAY) {
                    throw new RuntimeException("Cannot send packet protocol " + protocol + ". Only " + ConnectionProtocol.PLAY + " is allowed");
                }
                if (content instanceof BundlePacket) {
                    BundlePacket bundle = (BundlePacket)content;
                    buffer.writeInt(234920940);
                    int size = 0;
                    for (Packet subPacket : bundle.m_264216_()) {
                        ++size;
                    }
                    buffer.writeInt(size);
                    for (Packet subPacket : bundle.m_264216_()) {
                        this.write(subPacket, (Class)subPacket.getClass(), (Type)null, buffer);
                    }
                    return;
                }
                Integer id = protocol.m_264521_(PacketFlow.CLIENTBOUND, packet);
                if (id != -1) {
                    buffer.writeInt(id.intValue());
                    packet.m_5779_(buffer);
                } else {
                    buffer.writeInt(-protocol.m_264521_(PacketFlow.SERVERBOUND, packet));
                    packet.m_5779_(buffer);
                }
            }

            @Override
            public Packet read(Class classType, Type genericType, FriendlyByteBuf buffer) {
                int id = buffer.readInt();
                if (id == 234920940) {
                    int size = buffer.readInt();
                    ArrayList<Packet> packets = new ArrayList<Packet>();
                    for (int i = 0; i < size; ++i) {
                        packets.add(this.read(null, null, buffer));
                    }
                    return new ClientboundBundlePacket(packets);
                }
                if (id < 0) {
                    return ConnectionProtocol.PLAY.m_178321_(PacketFlow.SERVERBOUND, -id, buffer);
                }
                return ConnectionProtocol.PLAY.m_178321_(PacketFlow.CLIENTBOUND, id, buffer);
            }
        });
    }
}

