/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.GuiInfoStackButton;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientMaterial;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;

public abstract class CreativeIngredient {
    public static final NamedTypeRegistry<CreativeIngredient> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[0]);
    private static List<Function<Object, ? extends CreativeIngredient>> objectParsers = new ArrayList<Function<Object, ? extends CreativeIngredient>>();

    public static <T extends CreativeIngredient> void registerType(String id, Class<T> classType, Function<Object, T> parser) {
        REGISTRY.register(id, classType);
        if (parser != null) {
            objectParsers.add(parser);
        }
    }

    public static CreativeIngredient parse(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CreativeIngredient) {
            return (CreativeIngredient)object;
        }
        for (int i = 0; i < objectParsers.size(); ++i) {
            try {
                CreativeIngredient ingredient = objectParsers.get(i).apply(object);
                if (ingredient == null) continue;
                return ingredient;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CreativeIngredient load(CompoundTag nbt) {
        Class<CreativeIngredient> classType = REGISTRY.get(nbt.m_128461_("id"));
        if (classType == null) {
            throw new IllegalArgumentException("'" + nbt.m_128461_("id") + "' is an invalid type");
        }
        try {
            CreativeIngredient ingredient = classType.getConstructor(new Class[0]).newInstance(new Object[0]);
            ingredient.loadExtra(nbt);
            return ingredient;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("id", REGISTRY.getId(this));
        this.saveExtra(nbt);
        return nbt;
    }

    protected abstract void saveExtra(CompoundTag var1);

    protected abstract void loadExtra(CompoundTag var1);

    public abstract boolean is(ItemStack var1);

    public abstract boolean is(CreativeIngredient var1);

    public abstract ItemStack getExample();

    public abstract CreativeIngredient copy();

    public boolean equals(Object object) {
        return object instanceof CreativeIngredient && this.equals((CreativeIngredient)object);
    }

    public abstract boolean equals(CreativeIngredient var1);

    public abstract Component description();

    public abstract Component descriptionDetail();

    static {
        CreativeIngredient.registerType("block", CreativeIngredientBlock.class, x -> {
            Block block = null;
            if (x instanceof Block) {
                block = (Block)x;
            }
            if (x instanceof BlockItem) {
                block = Block.m_49814_((Item)((Item)x));
            }
            if (block != null && !(block instanceof AirBlock)) {
                return new CreativeIngredientBlock(block);
            }
            return null;
        });
        CreativeIngredient.registerType("blocktag", CreativeIngredientBlockTag.class, x -> {
            TagKey key;
            if (x instanceof TagKey && (key = (TagKey)x).m_207645_(Registries.f_256747_)) {
                return new CreativeIngredientBlockTag((TagKey<Block>)((TagKey)x));
            }
            return null;
        });
        CreativeIngredient.registerType("item", CreativeIngredientItem.class, x -> {
            if (x instanceof Item && !(x instanceof BlockItem)) {
                return new CreativeIngredientItem((Item)x);
            }
            return null;
        });
        CreativeIngredient.registerType("itemtag", CreativeIngredientItemTag.class, x -> {
            TagKey key;
            if (x instanceof TagKey && (key = (TagKey)x).m_207645_(Registries.f_256913_)) {
                return new CreativeIngredientItemTag((TagKey<Item>)((TagKey)x));
            }
            return null;
        });
        CreativeIngredient.registerType("itemstack", CreativeIngredientItemStack.class, x -> x instanceof ItemStack ? new CreativeIngredientItemStack((ItemStack)x, false) : null);
        CreativeIngredient.registerType("material", CreativeIngredientMaterial.class, x -> x instanceof Material ? new CreativeIngredientMaterial((Material)x) : null);
        CreativeIngredient.registerType("fuel", CreativeIngredientFuel.class, null);
        CreativeIngredientBlock temp = new CreativeIngredientBlock(Blocks.f_50493_);
        ConfigTypeConveration.registerSpecialType(x -> CreativeIngredient.class.isAssignableFrom((Class<?>)x), new ConfigTypeConveration.SimpleConfigTypeConveration<CreativeIngredient>(){

            @Override
            public CreativeIngredient readElement(CreativeIngredient defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    try {
                        return CreativeIngredient.load(TagParser.m_129359_((String)element.getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(CreativeIngredient value, CreativeIngredient defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value.save().toString());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz) {
                parent.add(new GuiInfoStackButton("data", CreativeIngredient.this).setExpandable());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(CreativeIngredient value, GuiParent parent) {
                GuiInfoStackButton button = (GuiInfoStackButton)parent.get("data");
                button.set(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected CreativeIngredient saveValue(GuiParent parent, Class clazz) {
                GuiInfoStackButton button = (GuiInfoStackButton)parent.get("data");
                return button.get();
            }

            @Override
            public CreativeIngredient set(ConfigKey.ConfigKeyField key, CreativeIngredient value) {
                return value;
            }
        });
    }
}

