/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.mc.MaterialUtils;

public class CreativeIngredientMaterial
extends CreativeIngredient {
    public Material material;

    public CreativeIngredientMaterial(Material material) {
        this.material = material;
    }

    public CreativeIngredientMaterial() {
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        nbt.m_128359_("material", BuiltInRegistries.f_256975_.m_7981_((Object)this.getBlock()).toString());
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(nbt.m_128461_("material")));
        if (block != null) {
            this.material = block.m_49966_().m_60767_();
        }
    }

    public Block getBlock() {
        for (Block block : BuiltInRegistries.f_256975_) {
            if (block.m_49966_().m_60767_() != this.material) continue;
            return block;
        }
        return null;
    }

    @Override
    public ItemStack getExample() {
        return new ItemStack((ItemLike)this.getBlock());
    }

    public static BlockState getState(ItemStack stack) {
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block != null) {
            return block.m_49966_();
        }
        return null;
    }

    @Override
    public boolean is(CreativeIngredient info) {
        return info instanceof CreativeIngredientMaterial && ((CreativeIngredientMaterial)info).material == this.material;
    }

    @Override
    public boolean is(ItemStack stack) {
        BlockState state = CreativeIngredientMaterial.getState(stack);
        if (state != null) {
            return state.m_60767_() == this.material;
        }
        return false;
    }

    @Override
    public boolean equals(CreativeIngredient object) {
        return object instanceof CreativeIngredientMaterial && ((CreativeIngredientMaterial)object).material == this.material;
    }

    @Override
    public CreativeIngredient copy() {
        return new CreativeIngredientMaterial(this.material);
    }

    @Override
    public Component description() {
        return Component.m_237113_((String)MaterialUtils.getName(this.material));
    }

    @Override
    public Component descriptionDetail() {
        return Component.m_237115_((String)"minecraft.material").m_130946_(": " + ChatFormatting.YELLOW + MaterialUtils.getName(this.material));
    }
}

