/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation;

import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.converation.ConfigTypeNamedList;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.gui.PermissionGuiLayer;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.premade.Permission;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.sync.GuiSyncGlobalLayer;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;

public class ConfigTypePermission
extends ConfigTypeNamedList<Permission> {
    public static final GuiSyncGlobalLayer<PermissionGuiLayer> PERMISSION_DIALOG = GuiSyncHolder.GLOBAL.layer("permission_dialog", t -> new PermissionGuiLayer());

    @Override
    protected Permission create(Class clazz) {
        return new Permission<Object>(ConfigTypeConveration.createObject(clazz));
    }

    @Override
    protected void addToList(Permission list, String name, Object object) {
        list.add(name, object);
    }

    @Override
    public boolean shouldSave(Permission value, GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key) {
        return !this.areEqual(value, (Permission)key.get(), key);
    }

    public boolean areEqual(Permission one, Permission two, Class clazz) {
        ConfigTypeConveration conversation = ConfigTypePermission.getUnsafe(clazz);
        if (one.size() != two.size()) {
            return false;
        }
        if (conversation != null && !conversation.areEqual(one.getDefault(), two.getDefault(), null)) {
            return false;
        }
        if (conversation == null && !one.getDefault().equals(two.getDefault()) && !EqualsBuilder.reflectionEquals(one.getDefault(), two.getDefault(), (boolean)false)) {
            return false;
        }
        for (Map.Entry entry : one.entrySet()) {
            Object other = two.getDirect(entry.getKey());
            if (conversation != null && !conversation.areEqual(entry.getValue(), other, null)) {
                return false;
            }
            if (conversation != null || entry.getValue().equals(other) || EqualsBuilder.reflectionEquals(entry.getValue(), other, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areEqual(Permission one, Permission two, @Nullable ConfigKey.ConfigKeyField key) {
        return this.areEqual(one, two, this.getListType(key));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void createControls(GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key, Class clazz) {
        parent.add(new GuiPermissionConfigButton("button", this, this.getListType(key), configParent));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void loadValue(Permission value, GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key) {
        GuiPermissionConfigButton button = (GuiPermissionConfigButton)parent.get("button");
        button.value = value;
        button.defaultValue = (Permission)key.getDefault();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected Permission saveValue(GuiParent parent, IGuiConfigParent configParent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
        return parent.get((String)"button", GuiPermissionConfigButton.class).value;
    }

    public static class GuiPermissionConfigButton
    extends GuiButton {
        public Permission<?> value;
        public Permission<?> defaultValue;
        public Class clazz;
        public ConfigTypePermission configTypePerm;
        public IGuiConfigParent configParent;

        public GuiPermissionConfigButton(String name, ConfigTypePermission configTypePerm, Class clazz, IGuiConfigParent configParent) {
            super(name, null);
            this.clazz = clazz;
            this.configTypePerm = configTypePerm;
            this.configParent = configParent;
            this.pressed = x -> {
                PermissionGuiLayer layer = PERMISSION_DIALOG.open(this.getIntegratedParent(), new CompoundTag());
                layer.button = this;
                layer.init();
            };
            this.setTranslate("gui.perm.open");
        }

        public void setNewValue(Permission permission) {
            this.value = permission;
            this.configParent.changed();
        }
    }
}

