/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.ParameterizedType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.GuiConfigSubControl;
import team.creative.creativecore.common.config.gui.GuiConfigSubControlHolder;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.holder.ConfigHolderObject;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.premade.ToggleableConfig;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.flow.GuiFlow;

public class ConfigTypeToggleable
extends ConfigTypeConveration<ToggleableConfig> {
    public Class getConfigType(ConfigKey.ConfigKeyField key) {
        ParameterizedType type = (ParameterizedType)key.field.getGenericType();
        return (Class)type.getActualTypeArguments()[0];
    }

    @Override
    public ToggleableConfig readElement(ToggleableConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
        Class clazz = this.getConfigType(key);
        if (element.isJsonObject()) {
            Object value;
            JsonObject object = element.getAsJsonObject();
            ConfigTypeConveration conversation = ConfigTypeToggleable.getUnsafe(clazz);
            if (conversation != null) {
                value = conversation.readElement(ConfigTypeConveration.createObject(clazz), loadDefault, ignoreRestart, object.get("content"), side, null);
            } else {
                value = ConfigTypeConveration.createObject(clazz);
                holderConveration.readElement(ConfigHolderObject.createUnrelated(side, value, value), loadDefault, ignoreRestart, object.get("content"), side, null);
            }
            return new ToggleableConfig<Object>(value, object.get("enabled").getAsBoolean());
        }
        return new ToggleableConfig(defaultValue.value, defaultValue.isEnabled());
    }

    @Override
    public JsonElement writeElement(ToggleableConfig value, ToggleableConfig defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, @Nullable ConfigKey.ConfigKeyField key) {
        Class clazz = this.getConfigType(key);
        ConfigTypeConveration conversation = ConfigTypeToggleable.getUnsafe(clazz);
        JsonObject object = new JsonObject();
        object.addProperty("enabled", Boolean.valueOf(value.isEnabled()));
        if (conversation != null) {
            object.add("content", conversation.writeElement(value.value, null, true, ignoreRestart, side, null));
        } else {
            object.add("content", holderConveration.writeElement(ConfigHolderObject.createUnrelated(side, value.value, value.value), null, true, ignoreRestart, side, null));
        }
        return object;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void createControls(GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key, Class clazz) {
        GuiConfigSubControl control;
        parent.flow = GuiFlow.STACK_Y;
        parent.add(new GuiCheckBox("enabled", true).setTranslate("gui.config.enabled"));
        Class subClass = this.getConfigType(key);
        ConfigTypeConveration converation = ConfigTypeToggleable.getUnsafe(subClass);
        if (converation != null) {
            control = new GuiConfigSubControl("content");
            converation.createControls(control, null, null, subClass);
        } else {
            control = new GuiConfigSubControlHolder("content", null, null, configParent::changed);
            ((GuiConfigSubControlHolder)control).createControls();
        }
        parent.add(control);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void loadValue(ToggleableConfig value, GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key) {
        parent.get((String)"enabled", GuiCheckBox.class).value = value.isEnabled();
        Class clazz = this.getConfigType(key);
        ConfigTypeConveration converation = ConfigTypeToggleable.getUnsafe(clazz);
        GuiConfigSubControl control = (GuiConfigSubControl)parent.get("content");
        if (converation != null) {
            converation.loadValue(value.value, control, null, null);
        } else {
            Object entry = ConfigTypeToggleable.copy(Side.SERVER, value.value, clazz);
            ((GuiConfigSubControlHolder)control).load(ConfigHolderObject.createUnrelated(Side.SERVER, entry, entry), entry);
            ((GuiConfigSubControlHolder)control).createControls();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected ToggleableConfig saveValue(GuiParent parent, IGuiConfigParent configParent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
        Object value;
        Class subClass = this.getConfigType(key);
        ConfigTypeConveration converation = ConfigTypeToggleable.getUnsafe(subClass);
        GuiConfigSubControl control = (GuiConfigSubControl)parent.get("content");
        if (converation != null) {
            value = converation.save(control, null, subClass, null);
        } else {
            ((GuiConfigSubControlHolder)control).save();
            value = ((GuiConfigSubControlHolder)control).value;
        }
        return new ToggleableConfig(value, parent.get((String)"enabled", GuiCheckBox.class).value);
    }

    @Override
    public ToggleableConfig set(ConfigKey.ConfigKeyField key, ToggleableConfig value) {
        return value;
    }

    @Override
    public boolean areEqual(ToggleableConfig one, ToggleableConfig two, @Nullable ConfigKey.ConfigKeyField key) {
        if (one.isEnabled() != two.isEnabled()) {
            return false;
        }
        Class clazz = this.getConfigType(key);
        ConfigTypeConveration conversation = ConfigTypeToggleable.getUnsafe(clazz);
        if (conversation != null && !conversation.areEqual(one.value, two.value, null)) {
            return false;
        }
        return conversation != null || one.value.equals(two.value);
    }
}

