/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.gui.GuiConfigControl;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.sync.ConfigurationChangePacket;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.parent.GuiColumn;
import team.creative.creativecore.common.gui.controls.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollY;
import team.creative.creativecore.common.gui.controls.parent.GuiTable;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.mc.JsonUtils;
import team.creative.creativecore.common.util.text.TextBuilder;

public class ConfigGuiLayer
extends GuiLayer {
    public JsonObject ROOT = new JsonObject();
    public Side side;
    public final ICreativeConfigHolder rootHolder;
    public ICreativeConfigHolder holder;
    public int nextAction;
    public boolean force;

    public ConfigGuiLayer(ICreativeConfigHolder holder, Side side) {
        super("config", 420, 234);
        this.flow = GuiFlow.STACK_Y;
        this.rootHolder = holder;
        this.holder = holder;
        this.side = side;
    }

    @Override
    public void create() {
        this.loadHolder(this.holder);
    }

    public void savePage() {
        GuiTable table = (GuiTable)this.get("box.table");
        JsonObject parent = null;
        for (GuiChildControl child : table) {
            JsonElement element;
            if (!(child.control instanceof GuiConfigControl) || (element = ((GuiConfigControl)child.control).save()) == null) continue;
            if (parent == null) {
                parent = JsonUtils.get(this.ROOT, this.holder.path());
            }
            parent.add(((GuiConfigControl)child.control).field.name, element);
        }
    }

    public void loadHolder(ICreativeConfigHolder holder) {
        if (!this.isEmpty()) {
            this.savePage();
            this.clear();
        }
        GuiLeftRightBox upperBox = new GuiLeftRightBox();
        upperBox.addLeft(new GuiLabel("path").setTitle((Component)Component.literal((String)("/" + String.join((CharSequence)"/", holder.path())))));
        upperBox.addRight(new GuiButton("back", x -> this.loadHolder(holder.parent())).setTranslate("gui.back").setEnabled(holder != this.rootHolder));
        this.holder = holder;
        this.add(upperBox);
        GuiScrollY box = new GuiScrollY("box").setDim(100, 100).setExpandable();
        this.add(box);
        GuiTable table = new GuiTable("table").setExpandable();
        box.add(table);
        JsonObject json = JsonUtils.tryGet(this.ROOT, holder.path());
        for (ConfigKey configKey : holder.fields()) {
            if (configKey.requiresRestart) continue;
            Object value = configKey.get();
            String path = "config." + String.join((CharSequence)".", holder.path());
            if (!path.endsWith(".")) {
                path = path + ".";
            }
            String caption = ConfigGuiLayer.translateOrDefault(path + configKey.name + ".name", configKey.name);
            String comment = path + configKey.name + ".comment";
            if (value instanceof ICreativeConfigHolder) {
                if (((ICreativeConfigHolder)value).isEmpty(this.side)) continue;
                GuiRow row = new GuiRow();
                table.addRow(row);
                GuiColumn col = new GuiColumn();
                row.addColumn(col);
                col.add(new GuiButton(caption, x -> this.loadHolder((ICreativeConfigHolder)value)).setTitle((Component)Component.literal((String)caption)).setTooltip(new TextBuilder().translateIfCan(comment).build()));
                continue;
            }
            if (!configKey.is(this.side)) continue;
            GuiConfigControl control = new GuiConfigControl((ConfigKey.ConfigKeyField)configKey, this.side, caption, comment);
            table.addRow(control);
            control.init(json != null ? json.get(configKey.name) : null);
        }
        GuiLeftRightBox lowerBox = new GuiLeftRightBox().addLeft(new GuiButton("cancel", x -> {
            this.nextAction = 0;
            this.closeTopLayer();
        }).setTitle((Component)Component.translatable((String)"gui.cancel")));
        if (this.side.isServer()) {
            lowerBox.addLeft(new GuiButton("client-config", x -> {
                this.nextAction = 1;
                this.closeTopLayer();
            }).setTitle((Component)Component.translatable((String)"gui.client-config")));
        }
        lowerBox.addRight(new GuiButton("save", x -> {
            this.nextAction = 0;
            this.savePage();
            this.sendUpdate();
            this.force = true;
            this.closeTopLayer();
        }).setTranslate("gui.save"));
        this.add(lowerBox);
        this.reinit();
    }

    public void sendUpdate() {
        if (this.side.isServer()) {
            this.getIntegratedParent().send(new ConfigurationChangePacket(this.rootHolder, this.ROOT));
        } else {
            this.rootHolder.load(false, true, JsonUtils.get(this.ROOT, this.rootHolder.path()), Side.CLIENT);
            CreativeCore.CONFIG_HANDLER.save(Side.CLIENT);
        }
    }

    @Override
    public void closeTopLayer() {
        this.savePage();
        if (this.force || this.ROOT.size() == 0) {
            if (this.nextAction == 0) {
                super.closeTopLayer();
            } else if (this.nextAction == 1) {
                CreativeCore.CONFIG_CLIENT_SYNC_OPEN.open(this.getPlayer());
            }
        } else {
            GuiDialogHandler.openDialog(this.getIntegratedParent(), "savechanges", (x, y) -> {
                if (y == DialogGuiLayer.DialogButton.YES) {
                    this.savePage();
                    this.sendUpdate();
                } else if (y != DialogGuiLayer.DialogButton.CANCEL) {
                    this.force = true;
                    this.closeTopLayer();
                }
            }, DialogGuiLayer.DialogButton.YES, DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.CANCEL);
        }
    }
}

