/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.minecraft.util.Mth;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonHoldSlim;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiCounterDecimal
extends GuiParent {
    public static final DecimalFormat FORMAT = new DecimalFormat("0.##");
    public double min;
    public double max;
    public GuiTextfield textfield;
    public double stepAmount = 1.0;

    public GuiCounterDecimal(String name, double value) {
        this(name, value, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public GuiCounterDecimal(String name, double value, double min, double max) {
        super(name);
        this.min = min;
        this.max = max;
        this.flow = GuiFlow.STACK_X;
        this.spacing = 1;
        this.textfield = new GuiTextfield("value", "" + Mth.clamp((double)value, (double)min, (double)max)).setDim(30, 10).setFloatOnly();
        this.add(this.textfield.setExpandableX());
        GuiParent buttons = new GuiParent(GuiFlow.STACK_Y);
        buttons.spacing = 0;
        this.add(buttons);
        buttons.add(new GuiButtonHoldSlim("+", x -> this.stepUp()).setTranslate("gui.plus").setDim(6, 3));
        buttons.add(new GuiButtonHoldSlim("-", x -> this.stepDown()).setTranslate("gui.minus").setDim(6, 3));
    }

    public GuiCounterDecimal setStep(double amount) {
        this.stepAmount = amount;
        return this;
    }

    public DecimalFormat getFormat() {
        return FORMAT;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }

    public void resetTextfield() {
        this.textfield.setCursorPositionZero();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void raiseEvent(GuiEvent event) {
        if (event instanceof GuiControlChangedEvent) {
            GuiControlChangedEvent controlEvent = (GuiControlChangedEvent)event;
            if (controlEvent.control.is("value")) {
                super.raiseEvent(new GuiControlChangedEvent(this));
                return;
            }
        }
        super.raiseEvent(event);
    }

    @Override
    public boolean isExpandableX() {
        return this.expandableX;
    }

    public void stepUp() {
        this.setValue(this.getValue() + this.stepAmount);
    }

    public void stepDown() {
        this.setValue(this.getValue() - this.stepAmount);
    }

    public double getValue() {
        return Mth.clamp((double)this.textfield.parseDouble(), (double)this.min, (double)this.max);
    }

    public void setValue(double value) {
        this.textfield.setText(this.getFormat().format(Mth.clamp((double)value, (double)this.min, (double)this.max)));
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    static {
        FORMAT.setRoundingMode(RoundingMode.HALF_UP);
    }
}

