/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiIcon;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.type.Color;

public class GuiIconButton
extends GuiControl {
    protected Consumer<Integer> pressed;
    protected GuiIcon icon;
    protected Color color = Color.WHITE;
    protected Color shadow = Color.BLACK;

    public GuiIconButton(String name, GuiIcon icon, Consumer<Integer> pressed) {
        super(name);
        this.setDim(12, 12);
        this.icon = icon;
        this.pressed = pressed;
    }

    public GuiIconButton(String name, int width, int height, GuiIcon icon, Consumer<Integer> pressed) {
        super(name);
        this.setDim(width, height);
        this.icon = icon;
        this.pressed = pressed;
    }

    public void setIcon(GuiIcon icon) {
        this.icon = icon;
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public void flowX(int width, int preferred) {
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 12;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 12;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        GuiIconButton.playSound((Holder.Reference<SoundEvent>)SoundEvents.UI_BUTTON_CLICK);
        if (this.pressed != null) {
            this.pressed.accept(button);
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        PoseStack pose = graphics.pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.icon.location());
        this.shadow.glColor();
        GuiRenderHelper.textureRect(pose, 1, 1, control.getContentWidth(), control.getContentHeight(), this.icon.minX(), this.icon.minY(), this.icon.minX() + this.icon.width(), this.icon.minY() + this.icon.height());
        this.color.glColor();
        GuiRenderHelper.textureRect(pose, 0, 0, control.getContentWidth(), control.getContentHeight(), this.icon.minX(), this.icon.minY(), this.icon.minX() + this.icon.width(), this.icon.minY() + this.icon.height());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

